/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosResponseDiagnostics;
import com.azure.cosmos.implementation.CosmosItemProperties;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.Utils;
import java.time.Duration;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncItemResponse<T> {
    private final Class<T> itemClassType;
    private final String responseBodyString;
    private T item;
    private final ResourceResponse<Document> resourceResponse;
    private CosmosItemProperties props;

    CosmosAsyncItemResponse(ResourceResponse<Document> response, Class<T> klass) {
        this.itemClassType = klass;
        this.responseBodyString = response.getBodyAsString();
        this.resourceResponse = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResource() {
        if (this.item != null) {
            return this.item;
        }
        if (this.itemClassType == CosmosItemProperties.class) {
            this.item = this.getProperties();
            return this.item;
        }
        if (this.item == null) {
            CosmosAsyncItemResponse cosmosAsyncItemResponse = this;
            synchronized (cosmosAsyncItemResponse) {
                if (this.item == null && !StringUtils.isEmpty((CharSequence)this.responseBodyString)) {
                    this.item = Utils.parse(this.responseBodyString, this.itemClassType);
                }
            }
        }
        return this.item;
    }

    CosmosItemProperties getProperties() {
        this.ensureCosmosItemPropertiesInitialized();
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCosmosItemPropertiesInitialized() {
        CosmosAsyncItemResponse cosmosAsyncItemResponse = this;
        synchronized (cosmosAsyncItemResponse) {
            this.props = StringUtils.isEmpty((CharSequence)this.responseBodyString) ? null : new CosmosItemProperties(this.responseBodyString);
        }
    }

    public String getMaxResourceQuota() {
        return this.resourceResponse.getMaxResourceQuota();
    }

    public String getCurrentResourceQuotaUsage() {
        return this.resourceResponse.getCurrentResourceQuotaUsage();
    }

    public String getActivityId() {
        return this.resourceResponse.getActivityId();
    }

    public double getRequestCharge() {
        return this.resourceResponse.getRequestCharge();
    }

    public int getStatusCode() {
        return this.resourceResponse.getStatusCode();
    }

    public String getSessionToken() {
        return this.resourceResponse.getSessionToken();
    }

    public Map<String, String> getResponseHeaders() {
        return this.resourceResponse.getResponseHeaders();
    }

    public CosmosResponseDiagnostics getCosmosResponseDiagnostics() {
        return this.resourceResponse.getCosmosResponseDiagnostics();
    }

    public Duration getRequestLatency() {
        return this.resourceResponse.getRequestLatency();
    }
}

