/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncTrigger;
import com.azure.cosmos.CosmosResponse;
import com.azure.cosmos.CosmosTriggerProperties;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.Trigger;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncTriggerResponse
extends CosmosResponse<CosmosTriggerProperties> {
    private final CosmosTriggerProperties cosmosTriggerProperties;
    private final CosmosAsyncTrigger cosmosTrigger;

    CosmosAsyncTriggerResponse(ResourceResponse<Trigger> response, CosmosAsyncContainer container) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            this.cosmosTriggerProperties = null;
            this.cosmosTrigger = null;
        } else {
            this.cosmosTriggerProperties = new CosmosTriggerProperties(bodyAsString);
            this.cosmosTrigger = new CosmosAsyncTrigger(this.cosmosTriggerProperties.getId(), container);
        }
    }

    @Override
    public CosmosTriggerProperties getProperties() {
        return this.cosmosTriggerProperties;
    }

    public CosmosAsyncTrigger getTrigger() {
        return this.cosmosTrigger;
    }
}

