/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncItemResponse;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosContainerResponse;
import com.azure.cosmos.CosmosContinuablePagedFlux;
import com.azure.cosmos.CosmosContinuablePagedIterable;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosItemRequestOptions;
import com.azure.cosmos.CosmosItemResponse;
import com.azure.cosmos.CosmosScripts;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.PartitionKey;
import com.azure.cosmos.SqlQuerySpec;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosContainer {
    final CosmosAsyncContainer asyncContainer;
    private final CosmosDatabase database;
    private final String id;
    private CosmosScripts scripts;

    CosmosContainer(String id, CosmosDatabase database, CosmosAsyncContainer container) {
        this.id = id;
        this.database = database;
        this.asyncContainer = container;
    }

    public String getId() {
        return this.id;
    }

    public CosmosContainerResponse read() throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.asyncContainer.read());
    }

    public CosmosContainerResponse read(CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.asyncContainer.read(options));
    }

    public CosmosContainerResponse delete(CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.asyncContainer.delete(options));
    }

    public CosmosContainerResponse delete() throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.asyncContainer.delete());
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.asyncContainer.replace(containerProperties));
    }

    public CosmosContainerResponse replace(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.database.mapContainerResponseAndBlock(this.asyncContainer.replace(containerProperties, options));
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return this.database.throughputResponseToBlock(this.asyncContainer.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return this.database.throughputResponseToBlock(this.asyncContainer.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    public <T> CosmosItemResponse<T> createItem(T item) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.createItem(item));
    }

    public <T> CosmosItemResponse<T> createItem(T item, PartitionKey partitionKey, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.createItem(item, partitionKey, options));
    }

    public <T> CosmosItemResponse<T> createItem(T item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.createItem(item, options));
    }

    public <T> CosmosItemResponse<T> upsertItem(T item) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.upsertItem(item));
    }

    public <T> CosmosItemResponse<T> upsertItem(Object item, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.upsertItem(item, options));
    }

    <T> CosmosItemResponse<T> mapItemResponseAndBlock(Mono<CosmosAsyncItemResponse<T>> itemMono) throws CosmosClientException {
        try {
            return (CosmosItemResponse)itemMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    private CosmosItemResponse mapDeleteItemResponseAndBlock(Mono<CosmosAsyncItemResponse> deleteItemMono) throws CosmosClientException {
        try {
            return (CosmosItemResponse)deleteItemMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw ex;
        }
    }

    public <T> CosmosContinuablePagedIterable<T> readAllItems(FeedOptions options, Class<T> klass) {
        return this.getCosmosContinuablePagedIterable(this.asyncContainer.readAllItems(options, klass));
    }

    public <T> CosmosContinuablePagedIterable<T> queryItems(String query, FeedOptions options, Class<T> klass) {
        return this.getCosmosContinuablePagedIterable(this.asyncContainer.queryItems(query, options, klass));
    }

    public <T> CosmosContinuablePagedIterable<T> queryItems(SqlQuerySpec querySpec, FeedOptions options, Class<T> klass) {
        return this.getCosmosContinuablePagedIterable(this.asyncContainer.queryItems(querySpec, options, klass));
    }

    public <T> CosmosItemResponse<T> readItem(String itemId, PartitionKey partitionKey, Class<T> itemType) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.readItem(itemId, partitionKey, new CosmosItemRequestOptions(), itemType));
    }

    public <T> CosmosItemResponse<T> readItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options, Class<T> itemType) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.readItem(itemId, partitionKey, options, itemType));
    }

    public <T> CosmosItemResponse<T> replaceItem(T item, String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapItemResponseAndBlock(this.asyncContainer.replaceItem(item, itemId, partitionKey, options));
    }

    public CosmosItemResponse deleteItem(String itemId, PartitionKey partitionKey, CosmosItemRequestOptions options) throws CosmosClientException {
        return this.mapDeleteItemResponseAndBlock(this.asyncContainer.deleteItem(itemId, partitionKey, options));
    }

    public CosmosScripts getScripts() {
        if (this.scripts == null) {
            this.scripts = new CosmosScripts(this, this.asyncContainer.getScripts());
        }
        return this.scripts;
    }

    private <T> CosmosItemResponse<T> convertResponse(CosmosAsyncItemResponse response) {
        return new CosmosItemResponse(response);
    }

    private <T> CosmosContinuablePagedIterable<T> getCosmosContinuablePagedIterable(CosmosContinuablePagedFlux<T> cosmosContinuablePagedFlux) {
        return new CosmosContinuablePagedIterable(cosmosContinuablePagedFlux);
    }
}

