/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainerResponse;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncUserResponse;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosContainerProperties;
import com.azure.cosmos.CosmosContainerRequestOptions;
import com.azure.cosmos.CosmosContainerResponse;
import com.azure.cosmos.CosmosContinuablePagedFlux;
import com.azure.cosmos.CosmosContinuablePagedIterable;
import com.azure.cosmos.CosmosDatabaseRequestOptions;
import com.azure.cosmos.CosmosDatabaseResponse;
import com.azure.cosmos.CosmosUser;
import com.azure.cosmos.CosmosUserProperties;
import com.azure.cosmos.CosmosUserResponse;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.SqlQuerySpec;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosDatabase {
    private final CosmosAsyncDatabase databaseWrapper;
    private final CosmosClient client;
    private final String id;

    CosmosDatabase(String id, CosmosClient client, CosmosAsyncDatabase database) {
        this.id = id;
        this.client = client;
        this.databaseWrapper = database;
    }

    public String getId() {
        return this.id;
    }

    public CosmosDatabaseResponse read() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read());
    }

    public CosmosDatabaseResponse read(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read(options));
    }

    public CosmosDatabaseResponse delete() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete());
    }

    public CosmosDatabaseResponse delete(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete(options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput, options));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath, throughput));
    }

    CosmosContainerResponse mapContainerResponseAndBlock(Mono<CosmosAsyncContainerResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosContainerResponse)containerMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    public CosmosContinuablePagedIterable<CosmosContainerProperties> readAllContainers(FeedOptions options) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.readAllContainers(options));
    }

    public CosmosContinuablePagedIterable<CosmosContainerProperties> readAllContainers() {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.readAllContainers());
    }

    public CosmosContinuablePagedIterable<CosmosContainerProperties> queryContainers(String query) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryContainers(query));
    }

    public CosmosContinuablePagedIterable<CosmosContainerProperties> queryContainers(String query, FeedOptions options) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryContainers(query, options));
    }

    public CosmosContinuablePagedIterable<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryContainers(querySpec));
    }

    public CosmosContinuablePagedIterable<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryContainers(querySpec, options));
    }

    public CosmosContainer getContainer(String id) {
        return new CosmosContainer(id, this, this.databaseWrapper.getContainer(id));
    }

    CosmosContainerResponse convertResponse(CosmosAsyncContainerResponse response) {
        return new CosmosContainerResponse(response, this, this.client);
    }

    public CosmosUserResponse createUser(CosmosUserProperties settings) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.createUser(settings));
    }

    public CosmosUserResponse upsertUser(CosmosUserProperties settings) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.upsertUser(settings));
    }

    public CosmosContinuablePagedIterable<CosmosUserProperties> readAllUsers() {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.readAllUsers());
    }

    public CosmosContinuablePagedIterable<CosmosUserProperties> readAllUsers(FeedOptions options) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.readAllUsers(options));
    }

    public CosmosContinuablePagedIterable<CosmosUserProperties> queryUsers(String query) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryUsers(query));
    }

    public CosmosContinuablePagedIterable<CosmosUserProperties> queryUsers(String query, FeedOptions options) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryUsers(query, options));
    }

    public CosmosContinuablePagedIterable<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryUsers(querySpec));
    }

    public CosmosContinuablePagedIterable<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosContinuablePagedIterable(this.databaseWrapper.queryUsers(querySpec, options));
    }

    public CosmosUser getUser(String id) {
        return new CosmosUser(this.databaseWrapper.getUser(id), this, id);
    }

    CosmosUserResponse mapUserResponseAndBlock(Mono<CosmosAsyncUserResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosUserResponse)containerMono.map(this::convertUserResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private CosmosUserResponse convertUserResponse(CosmosAsyncUserResponse response) {
        return new CosmosUserResponse(response, this);
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return this.throughputResponseToBlock(this.databaseWrapper.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return this.throughputResponseToBlock(this.databaseWrapper.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    Integer throughputResponseToBlock(Mono<Integer> throughputResponse) throws CosmosClientException {
        try {
            return (Integer)throughputResponse.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private <T> CosmosContinuablePagedIterable<T> getCosmosContinuablePagedIterable(CosmosContinuablePagedFlux<T> cosmosContinuablePagedFlux) {
        return new CosmosContinuablePagedIterable(cosmosContinuablePagedFlux);
    }
}

