/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosDatabase;
import com.azure.cosmos.CosmosUserProperties;
import com.azure.cosmos.CosmosUserResponse;

public class CosmosUser {
    private final CosmosAsyncUser asyncUser;
    private final CosmosDatabase database;
    private final String id;

    CosmosUser(CosmosAsyncUser asyncUser, CosmosDatabase database, String id) {
        this.asyncUser = asyncUser;
        this.database = database;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public CosmosUserResponse read() throws CosmosClientException {
        return this.database.mapUserResponseAndBlock(this.asyncUser.read());
    }

    public CosmosUserResponse replace(CosmosUserProperties userProperties) throws CosmosClientException {
        return this.database.mapUserResponseAndBlock(this.asyncUser.replace(userProperties));
    }

    public CosmosUserResponse delete() throws CosmosClientException {
        return this.database.mapUserResponseAndBlock(this.asyncUser.delete());
    }
}

