/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.DataType;
import com.azure.cosmos.HashIndex;
import com.azure.cosmos.IndexKind;
import com.azure.cosmos.JsonSerializable;
import com.azure.cosmos.RangeIndex;
import com.azure.cosmos.SpatialIndex;
import org.apache.commons.lang3.StringUtils;

public abstract class Index
extends JsonSerializable {
    Index(IndexKind indexKind) {
        this.setKind(indexKind);
    }

    Index(String jsonString, IndexKind indexKind) {
        super(jsonString);
        this.setKind(indexKind);
    }

    public static RangeIndex range(DataType dataType) {
        return new RangeIndex(dataType);
    }

    public static RangeIndex range(DataType dataType, int precision) {
        return new RangeIndex(dataType, precision);
    }

    public static HashIndex hash(DataType dataType) {
        return new HashIndex(dataType);
    }

    public static HashIndex hash(DataType dataType, int precision) {
        return new HashIndex(dataType, precision);
    }

    public static SpatialIndex spatial(DataType dataType) {
        return new SpatialIndex(dataType);
    }

    public IndexKind getKind() {
        IndexKind result = null;
        try {
            result = IndexKind.valueOf(StringUtils.upperCase((String)super.getString("kind")));
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("INVALID index kind value %s.", (Object)super.getString("kind"));
        }
        return result;
    }

    private Index setKind(IndexKind indexKind) {
        super.set("kind", indexKind.toString());
        return this;
    }
}

