/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.FeedResponse;
import com.azure.cosmos.PartitionKey;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import reactor.core.publisher.Mono;

public class ItemOperations {
    public static <T> FeedResponse<T> readMany(CosmosContainer container, List<Pair<String, PartitionKey>> itemKeyList, Class<T> klass) {
        return (FeedResponse)ItemOperations.readManyAsync(container.asyncContainer, itemKeyList, klass).block();
    }

    public static <T> Mono<FeedResponse<T>> readManyAsync(CosmosAsyncContainer container, List<Pair<String, PartitionKey>> itemKeyList, Class<T> klass) {
        FeedOptions options = new FeedOptions();
        options.setMaxDegreeOfParallelism(-1);
        return ItemOperations.readManyInternal(container, itemKeyList, new FeedOptions(), klass);
    }

    static <T> Mono<FeedResponse<T>> readManyInternal(CosmosAsyncContainer container, List<Pair<String, PartitionKey>> itemKeyList, FeedOptions options, Class<T> klass) {
        return container.getDatabase().getDocClientWrapper().readMany(itemKeyList, container.getLink(), options, klass);
    }
}

