/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;

public class PartitionKey {
    private final PartitionKeyInternal internalPartitionKey;
    private Object keyObject;
    public static final PartitionKey NONE = new PartitionKey(PartitionKeyInternal.None);

    PartitionKey(PartitionKeyInternal partitionKeyInternal) {
        this.internalPartitionKey = partitionKeyInternal;
    }

    public PartitionKey(Object key) {
        this.keyObject = key;
        this.internalPartitionKey = PartitionKeyInternal.fromObjectArray(new Object[]{key}, true);
    }

    Object getKeyObject() {
        return this.keyObject;
    }

    static PartitionKey fromJsonString(String jsonString) {
        return new PartitionKey(PartitionKeyInternal.fromJsonString(jsonString));
    }

    public String toString() {
        return this.internalPartitionKey.toJson();
    }

    PartitionKeyInternal getInternalPartitionKey() {
        return this.internalPartitionKey;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PartitionKey otherKey = Utils.as(other, PartitionKey.class);
        return otherKey != null && this.internalPartitionKey.equals(otherKey.internalPartitionKey);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

