/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.Resource;
import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class CosmosItemProperties
extends Resource {
    private static final ObjectMapper MAPPER = Utils.getSimpleObjectMapper();

    public CosmosItemProperties() {
    }

    @Override
    public CosmosItemProperties setId(String id) {
        super.setId(id);
        return this;
    }

    public CosmosItemProperties(String jsonString) {
        super(jsonString);
    }

    public CosmosItemProperties(ObjectNode propertyBag) {
        super(propertyBag);
    }

    public static Document fromObject(Object cosmosItem) {
        if (!(cosmosItem instanceof CosmosItemProperties)) {
            try {
                return new Document(MAPPER.writeValueAsString(cosmosItem));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        Document typedItem = new Document(((CosmosItemProperties)cosmosItem).toJson());
        return typedItem;
    }

    static String toJsonString(Object cosmosItem, ObjectMapper objectMapper) {
        if (cosmosItem instanceof CosmosItemProperties) {
            return ((CosmosItemProperties)cosmosItem).toJson();
        }
        if (cosmosItem instanceof Document) {
            return ((Document)cosmosItem).toJson();
        }
        try {
            return objectMapper.writeValueAsString(cosmosItem);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    static <T> List<T> getTypedResultsFromV2Results(List<Document> results, Class<T> klass) {
        return results.stream().map(document -> document.toObject(klass)).collect(Collectors.toList());
    }

    public <T> T getObject(Class<?> klass) throws IOException {
        return (T)MAPPER.readValue(this.toJson(), klass);
    }
}

