/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.FeedOptions;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.Exceptions;
import com.azure.cosmos.implementation.IRetryPolicy;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.caches.IPartitionKeyRangeCache;
import com.azure.cosmos.implementation.caches.RxCollectionCache;
import com.azure.cosmos.implementation.routing.CollectionRoutingMap;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class PartitionKeyRangeGoneRetryPolicy
extends DocumentClientRetryPolicy {
    private final RxCollectionCache collectionCache;
    private final DocumentClientRetryPolicy nextRetryPolicy;
    private final IPartitionKeyRangeCache partitionKeyRangeCache;
    private final String collectionLink;
    private final FeedOptions feedOptions;
    private volatile boolean retried;

    public PartitionKeyRangeGoneRetryPolicy(RxCollectionCache collectionCache, IPartitionKeyRangeCache partitionKeyRangeCache, String collectionLink, DocumentClientRetryPolicy nextRetryPolicy, FeedOptions feedOptions) {
        this.collectionCache = collectionCache;
        this.partitionKeyRangeCache = partitionKeyRangeCache;
        this.collectionLink = collectionLink;
        this.nextRetryPolicy = nextRetryPolicy;
        this.feedOptions = feedOptions;
    }

    @Override
    public Mono<IRetryPolicy.ShouldRetryResult> shouldRetry(Exception exception) {
        CosmosClientException clientException = Utils.as(exception, CosmosClientException.class);
        if (clientException != null && Exceptions.isStatusCode(clientException, 410) && Exceptions.isSubStatusCode(clientException, 1002)) {
            if (this.retried) {
                return Mono.just((Object)IRetryPolicy.ShouldRetryResult.error(clientException));
            }
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.Read, ResourceType.DocumentCollection, this.collectionLink, null);
            if (this.feedOptions != null) {
                request.properties = this.feedOptions.properties();
            }
            Mono<Utils.ValueHolder<DocumentCollection>> collectionObs = this.collectionCache.resolveCollectionAsync(request);
            return collectionObs.flatMap(collectionValueHolder -> {
                Mono<Utils.ValueHolder<CollectionRoutingMap>> routingMapObs = this.partitionKeyRangeCache.tryLookupAsync(((DocumentCollection)collectionValueHolder.v).getResourceId(), null, request.properties);
                Mono refreshedRoutingMapObs = routingMapObs.flatMap(routingMapValueHolder -> {
                    if (routingMapValueHolder.v != null) {
                        return this.partitionKeyRangeCache.tryLookupAsync(((DocumentCollection)collectionValueHolder.v).getResourceId(), (CollectionRoutingMap)routingMapValueHolder.v, request.properties);
                    }
                    return Mono.just(new Utils.ValueHolder<Object>(null));
                });
                return refreshedRoutingMapObs.flatMap(rm -> {
                    this.retried = true;
                    return Mono.just((Object)IRetryPolicy.ShouldRetryResult.retryAfter(Duration.ZERO));
                });
            });
        }
        return this.nextRetryPolicy.shouldRetry(exception);
    }

    @Override
    public void onBeforeSendRequest(RxDocumentServiceRequest request) {
        this.nextRetryPolicy.onBeforeSendRequest(request);
    }
}

