/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdEndpoint;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdObjectMapper;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestArgs;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdRequestRecord;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdServiceEndpoint;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.micrometer.core.instrument.Tag;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@JsonSerialize(using=JsonSerializer.class)
public final class RntbdTransportClient
extends TransportClient {
    private static final String TAG_NAME = RntbdTransportClient.class.getSimpleName();
    private static final AtomicLong instanceCount = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(RntbdTransportClient.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final RntbdEndpoint.Provider endpointProvider;
    private final long id;
    private final Tag tag;

    RntbdTransportClient(RntbdEndpoint.Provider endpointProvider) {
        this.endpointProvider = endpointProvider;
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
    }

    RntbdTransportClient(Options options, SslContext sslContext) {
        this.endpointProvider = new RntbdServiceEndpoint.Provider(this, options, sslContext);
        this.id = instanceCount.incrementAndGet();
        this.tag = RntbdTransportClient.tag(this.id);
    }

    RntbdTransportClient(Configs configs, int requestTimeoutInSeconds, UserAgentContainer userAgent) {
        this(new Options.Builder(requestTimeoutInSeconds).userAgent(userAgent).build(), configs.getSslContext());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            logger.debug("close {}", (Object)this);
            this.endpointProvider.close();
            return;
        }
        logger.debug("already closed {}", (Object)this);
    }

    public int endpointCount() {
        return this.endpointProvider.count();
    }

    public int endpointEvictionCount() {
        return this.endpointProvider.evictions();
    }

    public long id() {
        return this.id;
    }

    @Override
    public Mono<StoreResponse> invokeStoreAsync(Uri addressUri, RxDocumentServiceRequest request) {
        logger.debug("RntbdTransportClient.invokeStoreAsync({}, {})", (Object)addressUri, (Object)request);
        Preconditions.checkNotNull((Object)addressUri, (Object)"expected non-null address");
        Preconditions.checkNotNull((Object)request, (Object)"expected non-null request");
        this.throwIfClosed();
        URI address = addressUri.getURI();
        RntbdRequestArgs requestArgs = new RntbdRequestArgs(request, address);
        requestArgs.traceOperation(logger, null, "invokeStoreAsync", new Object[0]);
        RntbdEndpoint endpoint = this.endpointProvider.get(address);
        RntbdRequestRecord record = endpoint.request(requestArgs);
        logger.debug("RntbdTransportClient.invokeStoreAsync({}, {}): {}", new Object[]{address, request, record});
        return Mono.fromFuture((CompletableFuture)record.whenComplete((response, throwable) -> {
            record.stage(RntbdRequestRecord.Stage.COMPLETED);
            if (request.requestContext.cosmosResponseDiagnostics == null) {
                request.requestContext.cosmosResponseDiagnostics = BridgeInternal.createCosmosResponseDiagnostics();
            }
            if (response != null) {
                response.setRequestTimeline(record.takeTimelineSnapshot());
            }
        })).doOnCancel(() -> logger.debug("REQUEST CANCELLED: {}", (Object)record));
    }

    public Tag tag() {
        return this.tag;
    }

    public String toString() {
        return RntbdObjectMapper.toString(this);
    }

    private static Tag tag(long id) {
        return Tag.of((String)TAG_NAME, (String)Strings.padStart((String)Long.toHexString(id).toUpperCase(), (int)4, (char)'0'));
    }

    private void throwIfClosed() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (String)"%s is closed", (Object)this);
    }

    static final class JsonSerializer
    extends StdSerializer<RntbdTransportClient> {
        private static final long serialVersionUID = 1007663695768825670L;

        JsonSerializer() {
            super(RntbdTransportClient.class);
        }

        public void serialize(RntbdTransportClient value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            generator.writeNumberField("id", value.id());
            generator.writeBooleanField("isClosed", value.isClosed());
            generator.writeObjectField("configuration", (Object)value.endpointProvider.config());
            generator.writeObjectFieldStart("serviceEndpoints");
            generator.writeNumberField("count", value.endpointCount());
            generator.writeArrayFieldStart("items");
            Iterator iterator = value.endpointProvider.list().iterator();
            while (iterator.hasNext()) {
                generator.writeObject(iterator.next());
            }
            generator.writeEndArray();
            generator.writeEndObject();
            generator.writeEndObject();
        }
    }

    public static final class Options {
        @JsonProperty
        private final int bufferPageSize;
        @JsonProperty
        private final Duration connectionTimeout;
        @JsonProperty
        private final Duration idleChannelTimeout;
        @JsonProperty
        private final Duration idleEndpointTimeout;
        @JsonProperty
        private final int maxBufferCapacity;
        @JsonProperty
        private final int maxChannelsPerEndpoint;
        @JsonProperty
        private final int maxRequestsPerChannel;
        @JsonProperty
        private final Duration receiveHangDetectionTime;
        @JsonProperty
        private final Duration requestExpiryInterval;
        @JsonProperty
        private final Duration requestTimeout;
        @JsonProperty
        private final Duration requestTimerResolution;
        @JsonProperty
        private final Duration sendHangDetectionTime;
        @JsonProperty
        private final Duration shutdownTimeout;
        @JsonIgnore
        private final UserAgentContainer userAgent;

        private Options() {
            this.bufferPageSize = 8192;
            this.connectionTimeout = null;
            this.idleChannelTimeout = Duration.ZERO;
            this.idleEndpointTimeout = Duration.ofSeconds(70L);
            this.maxBufferCapacity = 0x800000;
            this.maxChannelsPerEndpoint = 10;
            this.maxRequestsPerChannel = 30;
            this.receiveHangDetectionTime = Duration.ofSeconds(65L);
            this.requestExpiryInterval = Duration.ofSeconds(5L);
            this.requestTimeout = null;
            this.requestTimerResolution = Duration.ofMillis(5L);
            this.sendHangDetectionTime = Duration.ofSeconds(10L);
            this.shutdownTimeout = Duration.ofSeconds(15L);
            this.userAgent = new UserAgentContainer();
        }

        private Options(Builder builder) {
            this.bufferPageSize = builder.bufferPageSize;
            this.idleChannelTimeout = builder.idleChannelTimeout;
            this.idleEndpointTimeout = builder.idleEndpointTimeout;
            this.maxBufferCapacity = builder.maxBufferCapacity;
            this.maxChannelsPerEndpoint = builder.maxChannelsPerEndpoint;
            this.maxRequestsPerChannel = builder.maxRequestsPerChannel;
            this.receiveHangDetectionTime = builder.receiveHangDetectionTime;
            this.requestExpiryInterval = builder.requestExpiryInterval;
            this.requestTimeout = builder.requestTimeout;
            this.requestTimerResolution = builder.requestTimerResolution;
            this.sendHangDetectionTime = builder.sendHangDetectionTime;
            this.shutdownTimeout = builder.shutdownTimeout;
            this.userAgent = builder.userAgent;
            this.connectionTimeout = builder.connectionTimeout == null ? builder.requestTimeout : builder.connectionTimeout;
        }

        public int bufferPageSize() {
            return this.bufferPageSize;
        }

        public Duration connectionTimeout() {
            return this.connectionTimeout;
        }

        public Duration idleChannelTimeout() {
            return this.idleChannelTimeout;
        }

        public Duration idleEndpointTimeout() {
            return this.idleEndpointTimeout;
        }

        public int maxBufferCapacity() {
            return this.maxBufferCapacity;
        }

        public int maxChannelsPerEndpoint() {
            return this.maxChannelsPerEndpoint;
        }

        public int maxRequestsPerChannel() {
            return this.maxRequestsPerChannel;
        }

        public Duration receiveHangDetectionTime() {
            return this.receiveHangDetectionTime;
        }

        public Duration requestExpiryInterval() {
            return this.requestExpiryInterval;
        }

        public Duration requestTimeout() {
            return this.requestTimeout;
        }

        public Duration requestTimerResolution() {
            return this.requestTimerResolution;
        }

        public Duration sendHangDetectionTime() {
            return this.sendHangDetectionTime;
        }

        public Duration shutdownTimeout() {
            return this.shutdownTimeout;
        }

        public UserAgentContainer userAgent() {
            return this.userAgent;
        }

        public String toString() {
            return RntbdObjectMapper.toJson(this);
        }

        public static class Builder {
            private static final String DEFAULT_OPTIONS_PROPERTY_NAME = "azure.cosmos.directTcp.defaultOptions";
            private static final Options DEFAULT_OPTIONS;
            private int bufferPageSize;
            private Duration connectionTimeout;
            private Duration idleChannelTimeout;
            private Duration idleEndpointTimeout;
            private int maxBufferCapacity;
            private int maxChannelsPerEndpoint;
            private int maxRequestsPerChannel;
            private Duration receiveHangDetectionTime;
            private Duration requestExpiryInterval;
            private Duration requestTimeout;
            private Duration requestTimerResolution;
            private Duration sendHangDetectionTime;
            private Duration shutdownTimeout;
            private UserAgentContainer userAgent;

            public Builder(Duration requestTimeout) {
                this.requestTimeout(requestTimeout);
                this.bufferPageSize = DEFAULT_OPTIONS.bufferPageSize;
                this.connectionTimeout = DEFAULT_OPTIONS.connectionTimeout;
                this.idleChannelTimeout = DEFAULT_OPTIONS.idleChannelTimeout;
                this.idleEndpointTimeout = DEFAULT_OPTIONS.idleEndpointTimeout;
                this.maxBufferCapacity = DEFAULT_OPTIONS.maxBufferCapacity;
                this.maxChannelsPerEndpoint = DEFAULT_OPTIONS.maxChannelsPerEndpoint;
                this.maxRequestsPerChannel = DEFAULT_OPTIONS.maxRequestsPerChannel;
                this.receiveHangDetectionTime = DEFAULT_OPTIONS.receiveHangDetectionTime;
                this.requestExpiryInterval = DEFAULT_OPTIONS.requestExpiryInterval;
                this.requestTimerResolution = DEFAULT_OPTIONS.requestTimerResolution;
                this.sendHangDetectionTime = DEFAULT_OPTIONS.sendHangDetectionTime;
                this.shutdownTimeout = DEFAULT_OPTIONS.shutdownTimeout;
                this.userAgent = DEFAULT_OPTIONS.userAgent;
            }

            public Builder(int requestTimeoutInSeconds) {
                this(Duration.ofSeconds(requestTimeoutInSeconds));
            }

            public Builder bufferPageSize(int value) {
                Preconditions.checkArgument((value >= 4096 && (value & value - 1) == 0 ? 1 : 0) != 0, (String)"expected value to be a power of 2 >= 4096, not %s", (int)value);
                this.bufferPageSize = value;
                return this;
            }

            public Options build() {
                Preconditions.checkState((this.bufferPageSize <= this.maxBufferCapacity ? 1 : 0) != 0, (String)"expected bufferPageSize (%s) <= maxBufferCapacity (%s)", (int)this.bufferPageSize, (int)this.maxBufferCapacity);
                return new Options(this);
            }

            public Builder connectionTimeout(Duration value) {
                Preconditions.checkArgument((value == null || value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.connectionTimeout = value;
                return this;
            }

            public Builder idleChannelTimeout(Duration value) {
                Preconditions.checkNotNull((Object)value, (Object)"expected non-null value");
                this.idleChannelTimeout = value;
                return this;
            }

            public Builder idleEndpointTimeout(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.idleEndpointTimeout = value;
                return this;
            }

            public Builder maxBufferCapacity(int value) {
                Preconditions.checkArgument((value > 0 && (value & value - 1) == 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (int)value);
                this.maxBufferCapacity = value;
                return this;
            }

            public Builder maxChannelsPerEndpoint(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (int)value);
                this.maxChannelsPerEndpoint = value;
                return this;
            }

            public Builder maxRequestsPerChannel(int value) {
                Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (int)value);
                this.maxRequestsPerChannel = value;
                return this;
            }

            public Builder receiveHangDetectionTime(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.receiveHangDetectionTime = value;
                return this;
            }

            public Builder requestExpiryInterval(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.requestExpiryInterval = value;
                return this;
            }

            public Builder requestTimeout(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.requestTimeout = value;
                return this;
            }

            public Builder requestTimerResolution(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.requestTimerResolution = value;
                return this;
            }

            public Builder sendHangDetectionTime(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.sendHangDetectionTime = value;
                return this;
            }

            public Builder shutdownTimeout(Duration value) {
                Preconditions.checkArgument((value != null && value.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (String)"expected positive value, not %s", (Object)value);
                this.shutdownTimeout = value;
                return this;
            }

            public Builder userAgent(UserAgentContainer value) {
                Preconditions.checkNotNull((Object)value, (Object)"expected non-null value");
                this.userAgent = value;
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            static {
                Options options;
                block27: {
                    options = null;
                    try {
                        String path;
                        String string = System.getProperty(DEFAULT_OPTIONS_PROPERTY_NAME);
                        if (string != null) {
                            try {
                                options = RntbdObjectMapper.readValue(string, Options.class);
                            }
                            catch (IOException error) {
                                logger.error("failed to parse default Direct TCP options {} due to ", (Object)string, (Object)error);
                            }
                        }
                        if (options == null && (path = System.getProperty("azure.cosmos.directTcp.defaultOptionsFile")) != null) {
                            try {
                                options = RntbdObjectMapper.readValue(new File(path), Options.class);
                            }
                            catch (IOException error) {
                                logger.error("failed to load default Direct TCP options from {} due to ", (Object)path, (Object)error);
                            }
                        }
                        if (options == null) {
                            ClassLoader loader = RntbdTransportClient.class.getClassLoader();
                            String name = "azure.cosmos.directTcp.defaultOptions.json";
                            try (InputStream stream = loader.getResourceAsStream("azure.cosmos.directTcp.defaultOptions.json");){
                                if (stream != null) {
                                    options = RntbdObjectMapper.readValue(stream, Options.class);
                                }
                            }
                            catch (IOException error) {
                                logger.error("failed to load Direct TCP options from resource {} due to ", (Object)"azure.cosmos.directTcp.defaultOptions.json", (Object)error);
                            }
                        }
                        if (options != null) break block27;
                        DEFAULT_OPTIONS = new Options();
                    }
                    catch (Throwable throwable) {
                        if (options == null) {
                            DEFAULT_OPTIONS = new Options();
                        } else {
                            logger.info("Updated default Direct TCP options from system property {}: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME, options);
                            DEFAULT_OPTIONS = options;
                        }
                        throw throwable;
                    }
                }
                logger.info("Updated default Direct TCP options from system property {}: {}", (Object)DEFAULT_OPTIONS_PROPERTY_NAME, (Object)options);
                DEFAULT_OPTIONS = options;
            }
        }
    }
}

