/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.Configs;
import java.net.InetSocketAddress;

public class HttpClientConfig {
    public static final String REACTOR_NETWORK_LOG_CATEGORY = "com.azure.cosmos.netty-network";
    private final Configs configs;
    private Integer maxPoolSize;
    private Integer maxIdleConnectionTimeoutInMillis;
    private Integer requestTimeoutInMillis;
    private InetSocketAddress proxy;
    private boolean connectionKeepAlive = true;

    public HttpClientConfig(Configs configs) {
        this.configs = configs;
    }

    public HttpClientConfig withPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public HttpClientConfig withHttpProxy(InetSocketAddress proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpClientConfig withMaxIdleConnectionTimeoutInMillis(int maxIdleConnectionTimeoutInMillis) {
        this.maxIdleConnectionTimeoutInMillis = maxIdleConnectionTimeoutInMillis;
        return this;
    }

    public HttpClientConfig withRequestTimeoutInMillis(int requestTimeoutInMillis) {
        this.requestTimeoutInMillis = requestTimeoutInMillis;
        return this;
    }

    public HttpClientConfig withConnectionKeepAlive(boolean connectionKeepAlive) {
        this.connectionKeepAlive = connectionKeepAlive;
        return this;
    }

    public Configs getConfigs() {
        return this.configs;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public Integer getMaxIdleConnectionTimeoutInMillis() {
        return this.maxIdleConnectionTimeoutInMillis;
    }

    public Integer getRequestTimeoutInMillis() {
        return this.requestTimeoutInMillis;
    }

    public InetSocketAddress getProxy() {
        return this.proxy;
    }

    public boolean isConnectionKeepAlive() {
        return this.connectionKeepAlive;
    }
}

