/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.http;

import com.azure.cosmos.implementation.RequestTimeline;
import java.time.OffsetDateTime;

public final class ReactorNettyRequestRecord {
    private volatile OffsetDateTime timeCreated;
    private volatile OffsetDateTime timeConnected;
    private volatile OffsetDateTime timeConfigured;
    private volatile OffsetDateTime timeSent;
    private volatile OffsetDateTime timeReceived;
    private volatile OffsetDateTime timeCompleted;

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OffsetDateTime timeConnected() {
        return this.timeConnected;
    }

    public OffsetDateTime timeConfigured() {
        return this.timeConfigured;
    }

    public OffsetDateTime timeSent() {
        return this.timeSent;
    }

    public OffsetDateTime timeReceived() {
        return this.timeReceived;
    }

    public OffsetDateTime timeCompleted() {
        return this.timeCompleted;
    }

    public void setTimeCreated(OffsetDateTime timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeConnected(OffsetDateTime timeConnected) {
        this.timeConnected = timeConnected;
    }

    public void setTimeConfigured(OffsetDateTime timeConfigured) {
        this.timeConfigured = timeConfigured;
    }

    public void setTimeSent(OffsetDateTime timeSent) {
        this.timeSent = timeSent;
    }

    public void setTimeReceived(OffsetDateTime timeReceived) {
        this.timeReceived = timeReceived;
    }

    public void setTimeCompleted(OffsetDateTime timeCompleted) {
        this.timeCompleted = timeCompleted;
    }

    public RequestTimeline takeTimelineSnapshot() {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime timeCreated = this.timeCreated();
        OffsetDateTime timeConnected = this.timeConnected();
        OffsetDateTime timeConfigured = this.timeConfigured();
        OffsetDateTime timeSent = this.timeSent();
        OffsetDateTime timeReceived = this.timeReceived();
        OffsetDateTime timeCompleted = this.timeCompleted();
        OffsetDateTime timeCompletedOrNow = timeCompleted == null ? now : timeCompleted;
        return RequestTimeline.of(new RequestTimeline.Event("connectionCreated", timeCreated, this.timeConnected() == null ? timeCompletedOrNow : timeConnected), new RequestTimeline.Event("connectionConfigured", timeConnected, timeConfigured == null ? timeCompletedOrNow : timeConfigured), new RequestTimeline.Event("requestSent", timeConfigured, timeSent == null ? timeCompletedOrNow : timeSent), new RequestTimeline.Event("transitTime", timeSent, timeReceived == null ? timeCompletedOrNow : timeReceived), new RequestTimeline.Event("received", timeReceived, timeCompletedOrNow));
    }
}

