/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.SqlQuerySpec;
import com.azure.cosmos.implementation.BackoffRetryUtility;
import com.azure.cosmos.implementation.DocumentClientRetryPolicy;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.PartitionedQueryExecutionInfo;
import com.azure.cosmos.implementation.query.QueryFeature;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Function;
import reactor.core.publisher.Mono;

class QueryPlanRetriever {
    private static final String TRUE = "True";
    private static final String SUPPORTED_QUERY_FEATURES = QueryFeature.Aggregate.name() + ", " + QueryFeature.CompositeAggregate.name() + ", " + QueryFeature.MultipleOrderBy.name() + ", " + QueryFeature.OrderBy.name() + ", " + QueryFeature.OffsetAndLimit.name() + ", " + QueryFeature.Top.name();

    QueryPlanRetriever() {
    }

    static Mono<PartitionedQueryExecutionInfo> getQueryPlanThroughGatewayAsync(IDocumentQueryClient queryClient, SqlQuerySpec sqlQuerySpec, String resourceLink) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        requestHeaders.put("x-ms-cosmos-is-query-plan-request", TRUE);
        requestHeaders.put("x-ms-cosmos-supported-query-features", SUPPORTED_QUERY_FEATURES);
        requestHeaders.put("x-ms-cosmos-query-version", "1.0");
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create(OperationType.QueryPlan, ResourceType.Document, resourceLink, requestHeaders);
        request.UseGatewayMode = true;
        request.setContentBytes(sqlQuerySpec.toJson().getBytes(StandardCharsets.UTF_8));
        DocumentClientRetryPolicy retryPolicyInstance = queryClient.getResetSessionTokenRetryPolicy().getRequestPolicy();
        Function<RxDocumentServiceRequest, Mono> executeFunc = req -> BackoffRetryUtility.executeRetry(() -> {
            retryPolicyInstance.onBeforeSendRequest((RxDocumentServiceRequest)req);
            return queryClient.executeQueryAsync(request).flatMap(rxDocumentServiceResponse -> {
                PartitionedQueryExecutionInfo partitionedQueryExecutionInfo = new PartitionedQueryExecutionInfo(rxDocumentServiceResponse.getReponseBodyAsString());
                return Mono.just((Object)partitionedQueryExecutionInfo);
            });
        }, retryPolicyInstance);
        return executeFunc.apply(request);
    }
}

