/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.implementation.query.metrics.SchedulingTimeSpan;
import org.apache.commons.lang3.time.StopWatch;

public class SchedulingStopwatch {
    private StopWatch turnaroundTimeStopwatch = new StopWatch();
    private StopWatch responseTimeStopwatch = new StopWatch();
    private StopWatch runTimeStopwatch = new StopWatch();
    private long numPreemptions;
    private boolean responded;

    public SchedulingTimeSpan getElapsedTime() {
        return new SchedulingTimeSpan(this.turnaroundTimeStopwatch.getTime(), this.responseTimeStopwatch.getTime(), this.runTimeStopwatch.getTime(), this.turnaroundTimeStopwatch.getTime() - this.runTimeStopwatch.getTime(), this.numPreemptions);
    }

    public void ready() {
        this.startStopWatch(this.turnaroundTimeStopwatch);
        this.startStopWatch(this.responseTimeStopwatch);
    }

    public void start() {
        if (!this.runTimeStopwatch.isStarted()) {
            if (!this.responded) {
                this.responseTimeStopwatch.stop();
                this.responded = true;
            }
            this.runTimeStopwatch.reset();
            this.startStopWatch(this.runTimeStopwatch);
        }
    }

    public void stop() {
        if (this.runTimeStopwatch.isStarted()) {
            this.stopStopWatch(this.runTimeStopwatch);
            ++this.numPreemptions;
        }
    }

    public void terminate() {
        this.stopStopWatch(this.turnaroundTimeStopwatch);
        this.stopStopWatch(this.responseTimeStopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopStopWatch(StopWatch stopwatch) {
        StopWatch stopWatch = stopwatch;
        synchronized (stopWatch) {
            stopwatch.stop();
        }
    }
}

