/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.CommonsBridgeInternal;
import com.azure.cosmos.PartitionKeyDefinition;
import com.azure.cosmos.PartitionKind;
import com.azure.cosmos.implementation.ByteBufferOutputStream;
import com.azure.cosmos.implementation.Bytes;
import com.azure.cosmos.implementation.routing.IPartitionKeyComponent;
import com.azure.cosmos.implementation.routing.Int128;
import com.azure.cosmos.implementation.routing.MurmurHash3_128;
import com.azure.cosmos.implementation.routing.MurmurHash3_32;
import com.azure.cosmos.implementation.routing.NumberPartitionKeyComponent;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.routing.UInt128;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class PartitionKeyInternalHelper {
    public static final String MinimumInclusiveEffectivePartitionKey = PartitionKeyInternalHelper.toHexEncodedBinaryString(PartitionKeyInternal.EmptyPartitionKey.components);
    public static final String MaximumExclusiveEffectivePartitionKey = PartitionKeyInternalHelper.toHexEncodedBinaryString(PartitionKeyInternal.InfinityPartitionKey.components);
    static final int MaxPartitionKeyBinarySize = 336;
    private static final Int128 MaxHashV2Value = new Int128(new byte[]{63, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});

    static byte[] uIntToBytes(UInt128 unit) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(unit.low);
        buffer.putLong(unit.high);
        return buffer.array();
    }

    static long asUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    static String toHexEncodedBinaryString(IPartitionKeyComponent ... components) {
        ByteBufferOutputStream stream = new ByteBufferOutputStream(336);
        for (IPartitionKeyComponent component : components) {
            component.WriteForBinaryEncoding(stream);
        }
        return HexConvert.bytesToHex(stream.asByteBuffer());
    }

    static String toHexEncodedBinaryString(List<IPartitionKeyComponent> components) {
        ByteBufferOutputStream stream = new ByteBufferOutputStream(336);
        for (IPartitionKeyComponent component : components) {
            component.WriteForBinaryEncoding(stream);
        }
        return HexConvert.bytesToHex(stream.asByteBuffer());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getEffectivePartitionKeyForHashPartitioningV2(PartitionKeyInternal partitionKeyInternal) {
        try (ByteBufferOutputStream byteArrayBuffer = new ByteBufferOutputStream();){
            for (int i = 0; i < partitionKeyInternal.components.size(); ++i) {
                partitionKeyInternal.components.get(i).WriteForHashingV2(byteArrayBuffer);
            }
            ByteBuffer byteBuffer = byteArrayBuffer.asByteBuffer();
            UInt128 hashAsUnit128 = MurmurHash3_128.hash128(byteBuffer.array(), byteBuffer.limit());
            byte[] hash = PartitionKeyInternalHelper.uIntToBytes(hashAsUnit128);
            Bytes.reverse(hash);
            hash[0] = (byte)(hash[0] & 0x3F);
            String string = HexConvert.bytesToHex(hash);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static String getEffectivePartitionKeyForHashPartitioning(PartitionKeyInternal partitionKeyInternal) {
        double hash;
        IPartitionKeyComponent[] truncatedComponents = new IPartitionKeyComponent[partitionKeyInternal.components.size()];
        for (int i = 0; i < truncatedComponents.length; ++i) {
            truncatedComponents[i] = partitionKeyInternal.components.get(i).Truncate();
        }
        try (ByteBufferOutputStream byteArrayBuffer = new ByteBufferOutputStream();){
            for (int i = 0; i < truncatedComponents.length; ++i) {
                truncatedComponents[i].WriteForHashing(byteArrayBuffer);
            }
            ByteBuffer byteBuffer = byteArrayBuffer.asByteBuffer();
            int hashAsInt = MurmurHash3_32.hash(byteBuffer.array(), byteBuffer.limit(), 0);
            hash = PartitionKeyInternalHelper.asUnsignedLong(hashAsInt);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        IPartitionKeyComponent[] partitionKeyComponents = new IPartitionKeyComponent[partitionKeyInternal.components.size() + 1];
        partitionKeyComponents[0] = new NumberPartitionKeyComponent(hash);
        for (int i = 0; i < truncatedComponents.length; ++i) {
            partitionKeyComponents[i + 1] = truncatedComponents[i];
        }
        return PartitionKeyInternalHelper.toHexEncodedBinaryString(partitionKeyComponents);
    }

    public static String getEffectivePartitionKeyString(PartitionKeyInternal partitionKeyInternal, PartitionKeyDefinition partitionKeyDefinition) {
        return PartitionKeyInternalHelper.getEffectivePartitionKeyString(partitionKeyInternal, partitionKeyDefinition, true);
    }

    public static String getEffectivePartitionKeyString(PartitionKeyInternal partitionKeyInternal, PartitionKeyDefinition partitionKeyDefinition, boolean strict) {
        if (partitionKeyInternal.components == null) {
            throw new IllegalArgumentException("PartitionKey has fewer components than defined the collection resource.");
        }
        if (partitionKeyInternal.equals(PartitionKeyInternal.EmptyPartitionKey)) {
            return MinimumInclusiveEffectivePartitionKey;
        }
        if (partitionKeyInternal.equals(PartitionKeyInternal.InfinityPartitionKey)) {
            return MaximumExclusiveEffectivePartitionKey;
        }
        if (partitionKeyInternal.components.size() < partitionKeyDefinition.getPaths().size()) {
            throw new IllegalArgumentException("PartitionKey has fewer components than defined the collection resource.");
        }
        if (partitionKeyInternal.components.size() > partitionKeyDefinition.getPaths().size() && strict) {
            throw new IllegalArgumentException("PartitionKey has more components than defined the collection resource.");
        }
        PartitionKind kind = partitionKeyDefinition.getKind();
        if (kind == null) {
            kind = PartitionKind.HASH;
        }
        switch (kind) {
            case HASH: {
                if (CommonsBridgeInternal.isV2(partitionKeyDefinition)) {
                    return PartitionKeyInternalHelper.getEffectivePartitionKeyForHashPartitioningV2(partitionKeyInternal);
                }
                return PartitionKeyInternalHelper.getEffectivePartitionKeyForHashPartitioning(partitionKeyInternal);
            }
        }
        return PartitionKeyInternalHelper.toHexEncodedBinaryString(partitionKeyInternal.components);
    }

    static class HexConvert {
        protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

        HexConvert() {
        }

        public static String bytesToHex(byte[] bytes) {
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }

        public static String bytesToHex(ByteBuffer byteBuffer) {
            char[] hexChars = new char[byteBuffer.limit() * 2];
            for (int j = 0; j < byteBuffer.limit(); ++j) {
                int v = byteBuffer.array()[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
    }
}

