/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.models.CosmosError;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class BadRequestException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    public BadRequestException(String message, Exception innerException) {
        super(message, innerException, new HashMap<String, String>(), 400, null);
    }

    public BadRequestException() {
        this("One of the input values is invalid.");
    }

    public BadRequestException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(400, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public BadRequestException(String message) {
        this(message, null, null, null);
    }

    BadRequestException(String message, HttpHeaders headers, String requestUrlString) {
        this(message, null, headers, requestUrlString);
    }

    public BadRequestException(String message, HttpHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    BadRequestException(Exception innerException) {
        this("One of the input values is invalid.", innerException, null, null);
    }

    BadRequestException(String message, Exception innerException, HttpHeaders headers, String requestUrlString) {
        super(String.format("%s: %s", "One of the input values is invalid.", message), innerException, HttpUtils.asMap(headers), 400, requestUrlString);
    }
}

