/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.RequestTimeline;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RetryContext;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.DirectBridgeInternal;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.StoreResult;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize(using=ClientSideRequestStatisticsSerializer.class)
class ClientSideRequestStatistics {
    private static final int MAX_SUPPLEMENTAL_REQUESTS_FOR_TO_STRING = 10;
    private static final DateTimeFormatter RESPONSE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss.SSS").withLocale(Locale.US);
    private ConnectionMode connectionMode;
    private List<StoreResponseStatistics> responseStatisticsList;
    private List<StoreResponseStatistics> supplementalResponseStatisticsList;
    private Map<String, AddressResolutionStatistics> addressResolutionStatistics;
    private List<URI> contactedReplicas;
    private Set<URI> failedReplicas;
    private ZonedDateTime requestStartTime = ZonedDateTime.now(ZoneOffset.UTC);
    private ZonedDateTime requestEndTime = ZonedDateTime.now(ZoneOffset.UTC);
    private Set<URI> regionsContacted;
    private RetryContext retryContext;
    private GatewayStatistics gatewayStatistics;
    private RequestTimeline transportRequestTimeline;

    ClientSideRequestStatistics() {
        this.responseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.supplementalResponseStatisticsList = new ArrayList<StoreResponseStatistics>();
        this.addressResolutionStatistics = new HashMap<String, AddressResolutionStatistics>();
        this.contactedReplicas = Collections.synchronizedList(new ArrayList());
        this.failedReplicas = Collections.synchronizedSet(new HashSet());
        this.regionsContacted = Collections.synchronizedSet(new HashSet());
        this.connectionMode = ConnectionMode.DIRECT;
        this.retryContext = this.retryContext;
    }

    private static String formatDateTime(ZonedDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(RESPONSE_TIME_FORMATTER);
    }

    Duration getRequestLatency() {
        return Duration.between(this.requestStartTime, this.requestEndTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordResponse(RxDocumentServiceRequest request, StoreResult storeResult) {
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.connectionMode = ConnectionMode.DIRECT;
        StoreResponseStatistics storeResponseStatistics = new StoreResponseStatistics();
        storeResponseStatistics.requestResponseTime = responseTime;
        storeResponseStatistics.storeResult = storeResult;
        storeResponseStatistics.requestOperationType = request.getOperationType();
        storeResponseStatistics.requestResourceType = request.getResourceType();
        URI locationEndPoint = null;
        if (request != null && request.requestContext != null) {
            this.retryContext = new RetryContext(request.requestContext.retryContext);
            if (request.requestContext.locationEndpointToRoute != null) {
                locationEndPoint = request.requestContext.locationEndpointToRoute;
            }
        }
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            if (locationEndPoint != null) {
                this.regionsContacted.add(locationEndPoint);
            }
            if (storeResponseStatistics.requestOperationType == OperationType.Head || storeResponseStatistics.requestOperationType == OperationType.HeadFeed) {
                this.supplementalResponseStatisticsList.add(storeResponseStatistics);
            } else {
                this.responseStatisticsList.add(storeResponseStatistics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordGatewayResponse(RxDocumentServiceRequest rxDocumentServiceRequest, StoreResponse storeResponse, CosmosClientException exception) {
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        this.connectionMode = ConnectionMode.GATEWAY;
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            if (rxDocumentServiceRequest != null && rxDocumentServiceRequest.requestContext != null && rxDocumentServiceRequest.requestContext.retryContext != null) {
                rxDocumentServiceRequest.requestContext.retryContext.retryEndTime = ZonedDateTime.now(ZoneOffset.UTC);
                this.retryContext = new RetryContext(rxDocumentServiceRequest.requestContext.retryContext);
            }
            this.gatewayStatistics = new GatewayStatistics();
            this.gatewayStatistics.operationType = rxDocumentServiceRequest.getOperationType();
            if (storeResponse != null) {
                this.gatewayStatistics.statusCode = storeResponse.getStatus();
                this.gatewayStatistics.subStatusCode = DirectBridgeInternal.getSubStatusCode(storeResponse);
                this.gatewayStatistics.sessionToken = storeResponse.getHeaderValue("x-ms-session-token");
                this.gatewayStatistics.requestCharge = storeResponse.getHeaderValue("x-ms-request-charge");
                this.gatewayStatistics.requestTimeline = DirectBridgeInternal.getRequestTimeline(storeResponse);
            } else if (exception != null) {
                this.gatewayStatistics.statusCode = exception.getStatusCode();
                this.gatewayStatistics.subStatusCode = exception.getSubStatusCode();
                this.gatewayStatistics.requestTimeline = this.transportRequestTimeline;
            }
        }
    }

    void setTransportClientRequestTimeline(RequestTimeline transportRequestTimeline) {
        this.transportRequestTimeline = transportRequestTimeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String recordAddressResolutionStart(URI targetEndpoint) {
        String identifier = Utils.randomUUID().toString();
        AddressResolutionStatistics resolutionStatistics = new AddressResolutionStatistics();
        resolutionStatistics.startTime = ZonedDateTime.now(ZoneOffset.UTC);
        resolutionStatistics.endTime = ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.UTC);
        resolutionStatistics.targetEndpoint = targetEndpoint == null ? "<NULL>" : targetEndpoint.toString();
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            this.addressResolutionStatistics.put(identifier, resolutionStatistics);
        }
        return identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordAddressResolutionEnd(String identifier) {
        if (StringUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        ZonedDateTime responseTime = ZonedDateTime.now(ZoneOffset.UTC);
        ClientSideRequestStatistics clientSideRequestStatistics = this;
        synchronized (clientSideRequestStatistics) {
            if (!this.addressResolutionStatistics.containsKey(identifier)) {
                throw new IllegalArgumentException("Identifier " + identifier + " does not exist. Please call start before calling end");
            }
            if (responseTime.isAfter(this.requestEndTime)) {
                this.requestEndTime = responseTime;
            }
            AddressResolutionStatistics resolutionStatistics = this.addressResolutionStatistics.get(identifier);
            resolutionStatistics.endTime = responseTime;
        }
    }

    List<URI> getContactedReplicas() {
        return this.contactedReplicas;
    }

    void setContactedReplicas(List<URI> contactedReplicas) {
        this.contactedReplicas = Collections.synchronizedList(contactedReplicas);
    }

    Set<URI> getFailedReplicas() {
        return this.failedReplicas;
    }

    void setFailedReplicas(Set<URI> failedReplicas) {
        this.failedReplicas = Collections.synchronizedSet(failedReplicas);
    }

    Set<URI> getRegionsContacted() {
        return this.regionsContacted;
    }

    void setRegionsContacted(Set<URI> regionsContacted) {
        this.regionsContacted = Collections.synchronizedSet(regionsContacted);
    }

    void recordRetryContext(RxDocumentServiceRequest request) {
        if (request.requestContext.retryContext != null) {
            request.requestContext.retryContext.retryEndTime = ZonedDateTime.now(ZoneOffset.UTC);
            this.retryContext = new RetryContext(request.requestContext.retryContext);
        }
    }

    private class GatewayStatistics {
        String sessionToken;
        OperationType operationType;
        int statusCode;
        int subStatusCode;
        String requestCharge;
        RequestTimeline requestTimeline;

        private GatewayStatistics() {
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public OperationType getOperationType() {
            return this.operationType;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public int getSubStatusCode() {
            return this.subStatusCode;
        }

        public String getRequestCharge() {
            return this.requestCharge;
        }

        public RequestTimeline getRequestTimeline() {
            return this.requestTimeline;
        }
    }

    private class AddressResolutionStatistics {
        @JsonSerialize(using=ZonedDateTimeSerializer.class)
        ZonedDateTime startTime;
        @JsonSerialize(using=ZonedDateTimeSerializer.class)
        ZonedDateTime endTime;
        String targetEndpoint;

        private AddressResolutionStatistics() {
        }
    }

    public static class ClientSideRequestStatisticsSerializer
    extends StdSerializer<ClientSideRequestStatistics> {
        ClientSideRequestStatisticsSerializer() {
            super(ClientSideRequestStatistics.class);
        }

        public void serialize(ClientSideRequestStatistics statistics, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeStartObject();
            long requestLatency = statistics.getRequestLatency().toMillis();
            generator.writeNumberField("requestLatency", requestLatency);
            generator.writeStringField("requestStartTime", ClientSideRequestStatistics.formatDateTime(statistics.requestStartTime));
            generator.writeStringField("requestEndTime", ClientSideRequestStatistics.formatDateTime(statistics.requestEndTime));
            generator.writeObjectField("connectionMode", (Object)statistics.connectionMode);
            generator.writeObjectField("responseStatisticsList", (Object)statistics.responseStatisticsList);
            int supplementalResponseStatisticsListCount = statistics.supplementalResponseStatisticsList.size();
            int initialIndex = Math.max(supplementalResponseStatisticsListCount - 10, 0);
            if (initialIndex != 0) {
                List subList = statistics.supplementalResponseStatisticsList.subList(initialIndex, supplementalResponseStatisticsListCount);
                generator.writeObjectField("supplementalResponseStatisticsList", subList);
            } else {
                generator.writeObjectField("supplementalResponseStatisticsList", (Object)statistics.supplementalResponseStatisticsList);
            }
            generator.writeObjectField("addressResolutionStatistics", (Object)statistics.addressResolutionStatistics);
            generator.writeObjectField("regionsContacted", (Object)statistics.regionsContacted);
            generator.writeObjectField("retryContext", (Object)statistics.retryContext);
            generator.writeObjectField("gatewayStatistics", (Object)statistics.gatewayStatistics);
            try {
                SystemInformation systemInformation = new SystemInformation();
                long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
                long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
                long maxMemory = Runtime.getRuntime().maxMemory() / 1024L;
                systemInformation.usedMemory = totalMemory - freeMemory + " KB";
                systemInformation.availableMemory = maxMemory - (totalMemory - freeMemory) + " KB";
                OperatingSystemMXBean mbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
                systemInformation.processCpuLoad = mbean.getProcessCpuLoad() * 100.0 + " %";
                systemInformation.systemCpuLoad = mbean.getSystemCpuLoad() * 100.0 + " %";
                generator.writeObjectField("systemInformation", (Object)systemInformation);
            }
            catch (Exception exception) {
                // empty catch block
            }
            generator.writeEndObject();
        }
    }

    private static class ZonedDateTimeSerializer
    extends StdSerializer<ZonedDateTime> {
        ZonedDateTimeSerializer() {
            super(ZonedDateTime.class);
        }

        public void serialize(ZonedDateTime zonedDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)ClientSideRequestStatistics.formatDateTime(zonedDateTime));
        }
    }

    private static class SystemInformation {
        String usedMemory;
        String availableMemory;
        String processCpuLoad;
        String systemCpuLoad;

        private SystemInformation() {
        }

        public String getUsedMemory() {
            return this.usedMemory;
        }

        public String getAvailableMemory() {
            return this.availableMemory;
        }

        public String getProcessCpuLoad() {
            return this.processCpuLoad;
        }

        public String getSystemCpuLoad() {
            return this.systemCpuLoad;
        }
    }

    static class StoreResponseStatistics {
        @JsonSerialize(using=StoreResult.StoreResultSerializer.class)
        StoreResult storeResult;
        @JsonSerialize(using=ZonedDateTimeSerializer.class)
        ZonedDateTime requestResponseTime;
        ResourceType requestResourceType;
        OperationType requestOperationType;

        StoreResponseStatistics() {
        }
    }
}

