/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.CosmosPagedFlux;
import com.azure.cosmos.implementation.AsyncDocumentClient;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdMetrics;
import com.azure.cosmos.models.CosmosAsyncDatabaseResponse;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.DatabaseAccount;
import com.azure.cosmos.models.FeedOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.Permission;
import com.azure.cosmos.models.SqlQuerySpec;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Closeable;
import java.util.List;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosAsyncClient
implements Closeable {
    private final Configs configs;
    private final AsyncDocumentClient asyncDocumentClient;
    private final String serviceEndpoint;
    private final String keyOrResourceToken;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel desiredConsistencyLevel;
    private final List<Permission> permissions;
    private final CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private final CosmosKeyCredential cosmosKeyCredential;
    private final boolean sessionCapturingOverride;
    private final boolean enableTransportClientSharing;

    CosmosAsyncClient(CosmosClientBuilder builder) {
        this.configs = builder.configs();
        this.serviceEndpoint = builder.getEndpoint();
        this.keyOrResourceToken = builder.getKey();
        this.connectionPolicy = builder.getConnectionPolicy();
        this.desiredConsistencyLevel = builder.getConsistencyLevel();
        this.permissions = builder.getPermissions();
        this.cosmosAuthorizationTokenResolver = builder.getCosmosAuthorizationTokenResolver();
        this.cosmosKeyCredential = builder.getCosmosKeyCredential();
        this.sessionCapturingOverride = builder.isSessionCapturingOverrideEnabled();
        this.enableTransportClientSharing = builder.isConnectionReuseAcrossClientsEnabled();
        this.asyncDocumentClient = new AsyncDocumentClient.Builder().withServiceEndpoint(this.serviceEndpoint).withMasterKeyOrResourceToken(this.keyOrResourceToken).withConnectionPolicy(this.connectionPolicy).withConsistencyLevel(this.desiredConsistencyLevel).withSessionCapturingOverride(this.sessionCapturingOverride).withConfigs(this.configs).withTokenResolver(this.cosmosAuthorizationTokenResolver).withCosmosKeyCredential(this.cosmosKeyCredential).withTransportClientSharing(this.enableTransportClientSharing).build();
    }

    AsyncDocumentClient getContextClient() {
        return this.asyncDocumentClient;
    }

    static void setMonitorTelemetry(MeterRegistry registry) {
        RntbdMetrics.add(registry);
    }

    String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    String getKeyOrResourceToken() {
        return this.keyOrResourceToken;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    ConsistencyLevel getDesiredConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    List<Permission> getPermissions() {
        return this.permissions;
    }

    AsyncDocumentClient getDocClientWrapper() {
        return this.asyncDocumentClient;
    }

    Configs getConfigs() {
        return this.configs;
    }

    CosmosAuthorizationTokenResolver getCosmosAuthorizationTokenResolver() {
        return this.cosmosAuthorizationTokenResolver;
    }

    CosmosKeyCredential cosmosKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabaseIfNotExists(CosmosDatabaseProperties databaseSettings) {
        return this.createDatabaseIfNotExistsInternal(this.getDatabase(databaseSettings.getId()));
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabaseIfNotExists(String id) {
        return this.createDatabaseIfNotExistsInternal(this.getDatabase(id));
    }

    private Mono<CosmosAsyncDatabaseResponse> createDatabaseIfNotExistsInternal(CosmosAsyncDatabase database) {
        return database.read().onErrorResume(exception -> {
            CosmosClientException cosmosClientException;
            Throwable unwrappedException = Exceptions.unwrap((Throwable)exception);
            if (unwrappedException instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)unwrappedException).getStatusCode() == 404) {
                return this.createDatabase(new CosmosDatabaseProperties(database.getId()), new CosmosDatabaseRequestOptions());
            }
            return Mono.error((Throwable)unwrappedException);
        });
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseSettings.getId());
        return this.asyncDocumentClient.createDatabase(wrappedDatabase, ModelBridgeInternal.toRequestOptions(options)).map(databaseResourceResponse -> ModelBridgeInternal.createCosmosAsyncDatabaseResponse(databaseResourceResponse, this)).single();
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings) {
        return this.createDatabase(databaseSettings, new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(String id) {
        return this.createDatabase(new CosmosDatabaseProperties(id), new CosmosDatabaseRequestOptions());
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, int throughput, CosmosDatabaseRequestOptions options) {
        if (options == null) {
            options = new CosmosDatabaseRequestOptions();
        }
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        Database wrappedDatabase = new Database();
        wrappedDatabase.setId(databaseSettings.getId());
        return this.asyncDocumentClient.createDatabase(wrappedDatabase, ModelBridgeInternal.toRequestOptions(options)).map(databaseResourceResponse -> ModelBridgeInternal.createCosmosAsyncDatabaseResponse(databaseResourceResponse, this)).single();
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(CosmosDatabaseProperties databaseSettings, int throughput) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        return this.createDatabase(databaseSettings, options);
    }

    public Mono<CosmosAsyncDatabaseResponse> createDatabase(String id, int throughput) {
        CosmosDatabaseRequestOptions options = new CosmosDatabaseRequestOptions();
        ModelBridgeInternal.setOfferThroughput(options, (Integer)throughput);
        return this.createDatabase(new CosmosDatabaseProperties(id), options);
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases(FeedOptions options) {
        return new CosmosPagedFlux<CosmosDatabaseProperties>(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().readDatabases(options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosDatabasePropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> readAllDatabases() {
        return this.readAllDatabases(new FeedOptions());
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(String query, FeedOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    public CosmosPagedFlux<CosmosDatabaseProperties> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return new CosmosPagedFlux<CosmosDatabaseProperties>(pagedFluxOptions -> {
            Utils.setContinuationTokenAndMaxItemCount(pagedFluxOptions, options);
            return this.getDocClientWrapper().queryDatabases(querySpec, options).map(response -> BridgeInternal.createFeedResponse(ModelBridgeInternal.getCosmosDatabasePropertiesFromV2Results(response.getResults()), response.getResponseHeaders()));
        });
    }

    public Mono<DatabaseAccount> readDatabaseAccount() {
        return this.asyncDocumentClient.getDatabaseAccount();
    }

    public CosmosAsyncDatabase getDatabase(String id) {
        return new CosmosAsyncDatabase(id, this);
    }

    @Override
    public void close() {
        this.asyncDocumentClient.close();
    }
}

