/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.models.Permission;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ServiceClientBuilder(serviceClients={CosmosClient.class, CosmosAsyncClient.class})
public class CosmosClientBuilder {
    private Configs configs = new Configs();
    private String serviceEndpoint;
    private String keyOrResourceToken;
    private ConnectionPolicy connectionPolicy;
    private ConsistencyLevel desiredConsistencyLevel;
    private List<Permission> permissions;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private CosmosKeyCredential cosmosKeyCredential;
    private boolean sessionCapturingOverrideEnabled;
    private boolean connectionReuseAcrossClientsEnabled;

    public CosmosClientBuilder setSessionCapturingOverrideEnabled(boolean sessionCapturingOverrideEnabled) {
        this.sessionCapturingOverrideEnabled = sessionCapturingOverrideEnabled;
        return this;
    }

    public boolean isSessionCapturingOverrideEnabled() {
        return this.sessionCapturingOverrideEnabled;
    }

    public CosmosClientBuilder setConnectionReuseAcrossClientsEnabled(boolean connectionReuseAcrossClientsEnabled) {
        this.connectionReuseAcrossClientsEnabled = true;
        return this;
    }

    public boolean isConnectionReuseAcrossClientsEnabled() {
        return this.connectionReuseAcrossClientsEnabled;
    }

    public CosmosAuthorizationTokenResolver getCosmosAuthorizationTokenResolver() {
        return this.cosmosAuthorizationTokenResolver;
    }

    public CosmosClientBuilder setCosmosAuthorizationTokenResolver(CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver) {
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
        return this;
    }

    public String getEndpoint() {
        return this.serviceEndpoint;
    }

    public CosmosClientBuilder setEndpoint(String endpoint) {
        this.serviceEndpoint = endpoint;
        return this;
    }

    public String getKey() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder setKey(String key) {
        this.keyOrResourceToken = key;
        return this;
    }

    public String getResourceToken() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder setResourceToken(String resourceToken) {
        this.keyOrResourceToken = resourceToken;
        return this;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public CosmosClientBuilder setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    public CosmosClientBuilder setConsistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        return this;
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public CosmosClientBuilder setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
        return this;
    }

    public CosmosKeyCredential getCosmosKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public CosmosClientBuilder setCosmosKeyCredential(CosmosKeyCredential cosmosKeyCredential) {
        this.cosmosKeyCredential = cosmosKeyCredential;
        return this;
    }

    public CosmosAsyncClient buildAsyncClient() {
        this.validateConfig();
        return new CosmosAsyncClient(this);
    }

    private void validateConfig() {
        this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot buildAsyncClient client without service endpoint");
        this.ifThrowIllegalArgException(this.keyOrResourceToken == null && (this.permissions == null || this.permissions.isEmpty()) && this.cosmosAuthorizationTokenResolver == null && this.cosmosKeyCredential == null, "cannot buildAsyncClient client without any one of key, resource token, permissions, token resolver, and cosmos key credential");
        this.ifThrowIllegalArgException(this.cosmosKeyCredential != null && StringUtils.isEmpty((CharSequence)this.cosmosKeyCredential.getKey()), "cannot buildAsyncClient client without key credential");
    }

    public CosmosClient buildClient() {
        this.validateConfig();
        return new CosmosClient(this);
    }

    Configs configs() {
        return this.configs;
    }

    CosmosClientBuilder configs(Configs configs) {
        this.configs = configs;
        return this;
    }

    private void ifThrowIllegalArgException(boolean value, String error) {
        if (value) {
            throw new IllegalArgumentException(error);
        }
    }
}

