/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosPagedFlux;
import com.azure.cosmos.CosmosPagedIterable;
import com.azure.cosmos.CosmosUser;
import com.azure.cosmos.models.CosmosAsyncContainerResponse;
import com.azure.cosmos.models.CosmosAsyncUserResponse;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosContainerRequestOptions;
import com.azure.cosmos.models.CosmosContainerResponse;
import com.azure.cosmos.models.CosmosDatabaseRequestOptions;
import com.azure.cosmos.models.CosmosDatabaseResponse;
import com.azure.cosmos.models.CosmosUserProperties;
import com.azure.cosmos.models.CosmosUserResponse;
import com.azure.cosmos.models.FeedOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosDatabase {
    private final CosmosAsyncDatabase databaseWrapper;
    private final CosmosClient client;
    private final String id;

    CosmosDatabase(String id, CosmosClient client, CosmosAsyncDatabase database) {
        this.id = id;
        this.client = client;
        this.databaseWrapper = database;
    }

    public String getId() {
        return this.id;
    }

    public CosmosDatabaseResponse read() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read());
    }

    public CosmosDatabaseResponse read(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.read(options));
    }

    public CosmosDatabaseResponse delete() throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete());
    }

    public CosmosDatabaseResponse delete(CosmosDatabaseRequestOptions options) throws CosmosClientException {
        return this.client.mapDatabaseResponseAndBlock(this.databaseWrapper.delete(options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, options));
    }

    public CosmosContainerResponse createContainer(CosmosContainerProperties containerProperties, int throughput, CosmosContainerRequestOptions options) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(containerProperties, throughput, options));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainer(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainer(id, partitionKeyPath, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties));
    }

    public CosmosContainerResponse createContainerIfNotExists(CosmosContainerProperties containerProperties, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(containerProperties, throughput));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath));
    }

    public CosmosContainerResponse createContainerIfNotExists(String id, String partitionKeyPath, int throughput) throws CosmosClientException {
        return this.mapContainerResponseAndBlock(this.databaseWrapper.createContainerIfNotExists(id, partitionKeyPath, throughput));
    }

    CosmosContainerResponse mapContainerResponseAndBlock(Mono<CosmosAsyncContainerResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosContainerResponse)containerMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    public CosmosPagedIterable<CosmosContainerProperties> readAllContainers(FeedOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllContainers(options));
    }

    public CosmosPagedIterable<CosmosContainerProperties> readAllContainers() {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllContainers());
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(String query) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(query));
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(String query, FeedOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(query, options));
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(querySpec));
    }

    public CosmosPagedIterable<CosmosContainerProperties> queryContainers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryContainers(querySpec, options));
    }

    public CosmosContainer getContainer(String id) {
        return new CosmosContainer(id, this, this.databaseWrapper.getContainer(id));
    }

    CosmosContainerResponse convertResponse(CosmosAsyncContainerResponse response) {
        return ModelBridgeInternal.createCosmosContainerResponse(response, this, this.client);
    }

    public CosmosUserResponse createUser(CosmosUserProperties userProperties) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.createUser(userProperties));
    }

    public CosmosUserResponse upsertUser(CosmosUserProperties userProperties) throws CosmosClientException {
        return this.mapUserResponseAndBlock(this.databaseWrapper.upsertUser(userProperties));
    }

    public CosmosPagedIterable<CosmosUserProperties> readAllUsers() {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllUsers());
    }

    public CosmosPagedIterable<CosmosUserProperties> readAllUsers(FeedOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.readAllUsers(options));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(String query) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(query));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(String query, FeedOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(query, options));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(querySpec));
    }

    public CosmosPagedIterable<CosmosUserProperties> queryUsers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosPagedIterable(this.databaseWrapper.queryUsers(querySpec, options));
    }

    public CosmosUser getUser(String id) {
        return new CosmosUser(this.databaseWrapper.getUser(id), this, id);
    }

    CosmosUserResponse mapUserResponseAndBlock(Mono<CosmosAsyncUserResponse> containerMono) throws CosmosClientException {
        try {
            return (CosmosUserResponse)containerMono.map(this::convertUserResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private CosmosUserResponse convertUserResponse(CosmosAsyncUserResponse response) {
        return ModelBridgeInternal.createCosmosUserResponse(response, this);
    }

    public Integer readProvisionedThroughput() throws CosmosClientException {
        return this.throughputResponseToBlock(this.databaseWrapper.readProvisionedThroughput());
    }

    public Integer replaceProvisionedThroughput(int requestUnitsPerSecond) throws CosmosClientException {
        return this.throughputResponseToBlock(this.databaseWrapper.replaceProvisionedThroughput(requestUnitsPerSecond));
    }

    Integer throughputResponseToBlock(Mono<Integer> throughputResponse) throws CosmosClientException {
        try {
            return (Integer)throughputResponse.block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)throwable;
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return new CosmosPagedIterable(cosmosPagedFlux);
    }
}

