/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.directconnectivity.HttpUtils;
import com.azure.cosmos.implementation.http.HttpHeaders;
import com.azure.cosmos.models.CosmosError;
import java.util.Map;

public class RequestEntityTooLargeException
extends CosmosClientException {
    private static final long serialVersionUID = 1L;

    RequestEntityTooLargeException() {
        this("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.");
    }

    public RequestEntityTooLargeException(CosmosError cosmosError, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(413, cosmosError, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    RequestEntityTooLargeException(String msg) {
        super(413, msg);
    }

    RequestEntityTooLargeException(String msg, String resourceAddress) {
        super(msg, null, null, 413, resourceAddress);
    }

    public RequestEntityTooLargeException(String message, HttpHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    RequestEntityTooLargeException(Exception innerException) {
        this("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", innerException, null, null);
    }

    RequestEntityTooLargeException(String message, Exception innerException, HttpHeaders headers, String requestUri) {
        super(String.format("The size of the response exceeded the maximum allowed size, limit the  response size by specifying smaller value for '%s' header.", message), innerException, HttpUtils.asMap(headers), 413, requestUri);
    }
}

