/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import java.time.Duration;

public class ThrottlingRetryOptions {
    private int maxRetryAttemptsOnThrottledRequests = 9;
    private Duration maxRetryWaitTime = Duration.ofSeconds(30L);

    public int getMaxRetryAttemptsOnThrottledRequests() {
        return this.maxRetryAttemptsOnThrottledRequests;
    }

    public ThrottlingRetryOptions setMaxRetryAttemptsOnThrottledRequests(int maxRetryAttemptsOnThrottledRequests) {
        if (maxRetryAttemptsOnThrottledRequests < 0) {
            throw new IllegalArgumentException("maxRetryAttemptsOnThrottledRequests value must be a positive integer.");
        }
        this.maxRetryAttemptsOnThrottledRequests = maxRetryAttemptsOnThrottledRequests;
        return this;
    }

    public Duration getMaxRetryWaitTime() {
        return this.maxRetryWaitTime;
    }

    public ThrottlingRetryOptions setMaxRetryWaitTime(Duration maxRetryWaitTime) {
        if (maxRetryWaitTime.getSeconds() < 0L || maxRetryWaitTime.getSeconds() > 2147483L) {
            throw new IllegalArgumentException("value must be a positive integer between the range of 0 to 2147483");
        }
        this.maxRetryWaitTime = maxRetryWaitTime;
        return this;
    }

    public String toString() {
        return "RetryOptions{maxRetryAttemptsOnThrottledRequests=" + this.maxRetryAttemptsOnThrottledRequests + ", maxRetryWaitTime=" + this.maxRetryWaitTime + '}';
    }
}

