/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.DatabaseAccountConfigurationProvider;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.DatabaseAccount;
import com.azure.cosmos.models.ModelBridgeInternal;

public class BaseDatabaseAccountConfigurationProvider
implements DatabaseAccountConfigurationProvider {
    private ConsistencyLevel desiredConsistencyLevel;
    private DatabaseAccount databaseAccount;

    public BaseDatabaseAccountConfigurationProvider(DatabaseAccount databaseAccount, ConsistencyLevel desiredConsistencyLevel) {
        this.databaseAccount = databaseAccount;
        this.desiredConsistencyLevel = desiredConsistencyLevel;
    }

    @Override
    public ConsistencyLevel getStoreConsistencyPolicy() {
        ConsistencyLevel databaseAccountConsistency = ModelBridgeInternal.getConsistencyPolicy(this.databaseAccount).getDefaultConsistencyLevel();
        if (this.desiredConsistencyLevel == null) {
            return databaseAccountConsistency;
        }
        if (!Utils.isValidConsistency(databaseAccountConsistency, this.desiredConsistencyLevel)) {
            throw new IllegalArgumentException(String.format("ConsistencyLevel %1s specified in the request is invalid when service is configured with consistency level %2s. Ensure the request consistency level is not stronger than the service consistency level.", this.desiredConsistencyLevel.toString(), databaseAccountConsistency.toString()));
        }
        return this.desiredConsistencyLevel;
    }

    @Override
    public int getMaxReplicaSetSize() {
        return ModelBridgeInternal.getReplicationPolicy(this.databaseAccount).getMaxReplicaSetSize();
    }

    @Override
    public String getQueryEngineConfiguration() {
        return this.databaseAccount.get("queryEngineConfiguration").toString();
    }
}

