/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.models.Resource;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class Document
extends Resource {
    public Document(ObjectNode objectNode) {
        super(objectNode);
    }

    public Document() {
    }

    @Override
    public Document setId(String id) {
        super.setId(id);
        return this;
    }

    public Document(String jsonString) {
        super(jsonString);
    }

    public static Document FromObject(Object document, ObjectMapper objectMapper) {
        if (!(document instanceof Document)) {
            try {
                return new Document(objectMapper.writeValueAsString(document));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        Document typedDocument = (Document)document;
        return typedDocument;
    }

    public Integer getTimeToLive() {
        if (super.has("ttl")) {
            return super.getInt("ttl");
        }
        return null;
    }

    public void setTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            BridgeInternal.setProperty(this, "ttl", timeToLive);
        } else if (super.has("ttl")) {
            this.remove("ttl");
        }
    }
}

