/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.Resource;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;

public final class DocumentCollection
extends Resource {
    private IndexingPolicy indexingPolicy;
    private UniqueKeyPolicy uniqueKeyPolicy;
    private PartitionKeyDefinition partitionKeyDefinition;

    public DocumentCollection(ObjectNode objectNode) {
        super(objectNode);
    }

    public DocumentCollection() {
    }

    @Override
    public DocumentCollection setId(String id) {
        super.setId(id);
        return this;
    }

    public DocumentCollection(String jsonString) {
        super(jsonString);
    }

    public IndexingPolicy getIndexingPolicy() {
        if (this.indexingPolicy == null) {
            this.indexingPolicy = super.has("indexingPolicy") ? super.getObject("indexingPolicy", IndexingPolicy.class, new boolean[0]) : new IndexingPolicy();
        }
        return this.indexingPolicy;
    }

    public void setIndexingPolicy(IndexingPolicy indexingPolicy) {
        if (indexingPolicy == null) {
            throw new IllegalArgumentException("IndexingPolicy cannot be null.");
        }
        this.indexingPolicy = indexingPolicy;
    }

    public PartitionKeyDefinition getPartitionKey() {
        if (this.partitionKeyDefinition == null) {
            this.partitionKeyDefinition = super.has("partitionKey") ? super.getObject("partitionKey", PartitionKeyDefinition.class, new boolean[0]) : new PartitionKeyDefinition();
        }
        return this.partitionKeyDefinition;
    }

    public void setPartitionKey(PartitionKeyDefinition partitionKey) {
        if (partitionKey == null) {
            throw new IllegalArgumentException("partitionKeyDefinition cannot be null.");
        }
        this.partitionKeyDefinition = partitionKey;
    }

    public Integer getDefaultTimeToLive() {
        if (super.has("defaultTtl")) {
            return super.getInt("defaultTtl");
        }
        return null;
    }

    public void setDefaultTimeToLive(Integer timeToLive) {
        if (timeToLive != null) {
            BridgeInternal.setProperty(this, "defaultTtl", timeToLive);
        } else if (super.has("defaultTtl")) {
            this.remove("defaultTtl");
        }
    }

    public UniqueKeyPolicy getUniqueKeyPolicy() {
        if (this.uniqueKeyPolicy == null) {
            this.uniqueKeyPolicy = super.getObject("uniqueKeyPolicy", UniqueKeyPolicy.class, new boolean[0]);
            if (this.uniqueKeyPolicy == null) {
                this.uniqueKeyPolicy = new UniqueKeyPolicy();
            }
        }
        return this.uniqueKeyPolicy;
    }

    public void setUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        if (uniqueKeyPolicy == null) {
            throw new IllegalArgumentException("uniqueKeyPolicy cannot be null.");
        }
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        BridgeInternal.setProperty(this, "uniqueKeyPolicy", uniqueKeyPolicy);
    }

    public ConflictResolutionPolicy getConflictResolutionPolicy() {
        return super.getObject("conflictResolutionPolicy", ConflictResolutionPolicy.class, new boolean[0]);
    }

    public void setConflictResolutionPolicy(ConflictResolutionPolicy value) {
        if (value == null) {
            throw new IllegalArgumentException("CONFLICT_RESOLUTION_POLICY cannot be null.");
        }
        BridgeInternal.setProperty(this, "conflictResolutionPolicy", value);
    }

    public String getDocumentsLink() {
        return String.format("%s/%s", StringUtils.stripEnd((String)super.getSelfLink(), (String)"/"), super.getString("_docs"));
    }

    public String getStoredProceduresLink() {
        return String.format("%s/%s", StringUtils.stripEnd((String)super.getSelfLink(), (String)"/"), super.getString("_sprocs"));
    }

    public String getTriggersLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_triggers");
    }

    public String getUserDefinedFunctionsLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_udfs");
    }

    public String getConflictsLink() {
        return StringUtils.removeEnd((String)this.getSelfLink(), (String)"/") + "/" + super.getString("_conflicts");
    }

    @Override
    protected void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.indexingPolicy == null) {
            this.getIndexingPolicy();
        }
        if (this.uniqueKeyPolicy == null) {
            this.getUniqueKeyPolicy();
        }
        if (this.partitionKeyDefinition != null) {
            ModelBridgeInternal.populatePropertyBagJsonSerializable(this.partitionKeyDefinition);
            BridgeInternal.setProperty(this, "partitionKey", this.partitionKeyDefinition);
        }
        ModelBridgeInternal.populatePropertyBagJsonSerializable(this.indexingPolicy);
        ModelBridgeInternal.populatePropertyBagJsonSerializable(this.uniqueKeyPolicy);
        BridgeInternal.setProperty(this, "indexingPolicy", this.indexingPolicy);
        BridgeInternal.setProperty(this, "uniqueKeyPolicy", this.uniqueKeyPolicy);
    }

    public boolean equals(Object obj) {
        if (obj == null || !DocumentCollection.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        DocumentCollection typedObj = (DocumentCollection)obj;
        return typedObj.getResourceId().equals(this.getResourceId());
    }

    public int hashCode() {
        return this.getResourceId().hashCode();
    }

    @Override
    public String toJson() {
        this.populatePropertyBag();
        return super.toJson();
    }
}

