/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.IRetryPolicy;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public abstract class RetryPolicyWithDiagnostics
implements IRetryPolicy {
    private volatile int retriesCountForDiagnostics;
    private volatile ZonedDateTime retryStartTime;
    private volatile ZonedDateTime retryEndTime;
    private volatile List<int[]> statusAndSubStatusCodes;

    @Override
    public ZonedDateTime getStartTime() {
        return this.retryStartTime;
    }

    @Override
    public ZonedDateTime getEndTime() {
        return this.retryEndTime;
    }

    @Override
    public void addStatusAndSubStatusCode(Integer index, int statusCode, int subStatusCode) {
        if (this.statusAndSubStatusCodes == null) {
            this.statusAndSubStatusCodes = new ArrayList<int[]>();
        }
        int[] statusAndSubStatusCode = new int[]{statusCode, subStatusCode};
        if (index == null) {
            this.statusAndSubStatusCodes.add(statusAndSubStatusCode);
        } else {
            this.statusAndSubStatusCodes.add(index, statusAndSubStatusCode);
        }
    }

    @Override
    public List<int[]> getStatusAndSubStatusCodes() {
        return this.statusAndSubStatusCodes;
    }

    @Override
    public int getRetryCount() {
        return this.retriesCountForDiagnostics;
    }

    @Override
    public void incrementRetry() {
        ++this.retriesCountForDiagnostics;
    }

    @Override
    public Duration getRetryLatency() {
        if (this.retryStartTime != null && this.retryEndTime != null) {
            return Duration.between(this.retryStartTime, this.retryEndTime);
        }
        return null;
    }

    @Override
    public void updateEndTime() {
        this.retryEndTime = ZonedDateTime.now(ZoneOffset.UTC);
    }

    @Override
    public void captureStartTimeIfNotSet() {
        if (this.retryStartTime == null) {
            this.retryStartTime = ZonedDateTime.now(ZoneOffset.UTC);
        }
    }
}

