/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.implementation;

import com.azure.cosmos.ChangeFeedProcessor;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.changefeed.ChangeFeedContextClient;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserver;
import com.azure.cosmos.implementation.changefeed.ChangeFeedObserverFactory;
import com.azure.cosmos.implementation.changefeed.CheckpointFrequency;
import com.azure.cosmos.implementation.changefeed.HealthMonitor;
import com.azure.cosmos.implementation.changefeed.LeaseStoreManager;
import com.azure.cosmos.implementation.changefeed.PartitionLoadBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.PartitionManager;
import com.azure.cosmos.implementation.changefeed.PartitionProcessorFactory;
import com.azure.cosmos.implementation.changefeed.implementation.BootstrapperImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedContextClientImpl;
import com.azure.cosmos.implementation.changefeed.implementation.ChangeFeedObserverFactoryImpl;
import com.azure.cosmos.implementation.changefeed.implementation.CheckpointerObserverFactory;
import com.azure.cosmos.implementation.changefeed.implementation.DefaultObserverFactory;
import com.azure.cosmos.implementation.changefeed.implementation.EqualPartitionsBalancingStrategy;
import com.azure.cosmos.implementation.changefeed.implementation.HealthMonitoringPartitionControllerDecorator;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionControllerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionLoadBalancerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionManagerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionProcessorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionSupervisorFactoryImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionSynchronizerImpl;
import com.azure.cosmos.implementation.changefeed.implementation.PartitionedByIdCollectionRequestOptionsFactory;
import com.azure.cosmos.implementation.changefeed.implementation.TraceHealthMonitor;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ChangeFeedProcessorBuilderImpl
implements ChangeFeedProcessor.BuilderDefinition,
ChangeFeedProcessor,
AutoCloseable {
    private static final long DefaultUnhealthinessDuration = Duration.ofMinutes(15L).toMillis();
    private final Duration sleepTime = Duration.ofSeconds(15L);
    private final Duration lockTime = Duration.ofSeconds(30L);
    private static final int DefaultQueryPartitionsMaxBatchSize = 100;
    private int queryPartitionsMaxBatchSize = 100;
    private int degreeOfParallelism = 25;
    private String hostName;
    private ChangeFeedContextClient feedContextClient;
    private ChangeFeedProcessorOptions changeFeedProcessorOptions;
    private ChangeFeedObserverFactory observerFactory;
    private volatile String databaseResourceId;
    private volatile String collectionResourceId;
    private ChangeFeedContextClient leaseContextClient;
    private PartitionLoadBalancingStrategy loadBalancingStrategy;
    private PartitionProcessorFactory partitionProcessorFactory;
    private LeaseStoreManager leaseStoreManager;
    private HealthMonitor healthMonitor;
    private volatile PartitionManager partitionManager;
    private Scheduler scheduler;

    @Override
    public Mono<Void> start() {
        if (this.partitionManager == null) {
            return this.initializeCollectionPropertiesForBuild().flatMap(value -> this.getLeaseStoreManager().flatMap(leaseStoreManager -> this.buildPartitionManager((LeaseStoreManager)leaseStoreManager))).flatMap(partitionManager1 -> {
                this.partitionManager = partitionManager1;
                return this.partitionManager.start();
            });
        }
        return this.partitionManager.start();
    }

    @Override
    public Mono<Void> stop() {
        if (this.partitionManager == null || !this.partitionManager.isRunning()) {
            throw new IllegalStateException("The ChangeFeedProcessor instance has not fully started");
        }
        return this.partitionManager.stop();
    }

    @Override
    public ChangeFeedProcessorBuilderImpl setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @Override
    public ChangeFeedProcessorBuilderImpl setFeedContainer(CosmosAsyncContainer feedDocumentClient) {
        if (feedDocumentClient == null) {
            throw new IllegalArgumentException("feedContextClient");
        }
        this.feedContextClient = new ChangeFeedContextClientImpl(feedDocumentClient);
        return this;
    }

    @Override
    public ChangeFeedProcessorBuilderImpl setOptions(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
        if (changeFeedProcessorOptions == null) {
            throw new IllegalArgumentException("changeFeedProcessorOptions");
        }
        this.changeFeedProcessorOptions = changeFeedProcessorOptions;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl observerFactory(ChangeFeedObserverFactory observerFactory) {
        if (observerFactory == null) {
            throw new IllegalArgumentException("observerFactory");
        }
        this.observerFactory = observerFactory;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl observer(Class<? extends ChangeFeedObserver> type) {
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        this.observerFactory = new ChangeFeedObserverFactoryImpl(type);
        return this;
    }

    @Override
    public ChangeFeedProcessorBuilderImpl setHandleChanges(Consumer<List<JsonNode>> consumer) {
        return this.observerFactory(new DefaultObserverFactory(consumer));
    }

    public ChangeFeedProcessorBuilderImpl withDatabaseResourceId(String databaseResourceId) {
        this.databaseResourceId = databaseResourceId;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl withCollectionResourceId(String collectionResourceId) {
        this.collectionResourceId = collectionResourceId;
        return this;
    }

    @Override
    public ChangeFeedProcessorBuilderImpl setLeaseContainer(CosmosAsyncContainer leaseDocumentClient) {
        if (leaseDocumentClient == null) {
            throw new IllegalArgumentException("leaseContextClient");
        }
        this.leaseContextClient = new ChangeFeedContextClientImpl(leaseDocumentClient);
        return this;
    }

    public ChangeFeedProcessorBuilderImpl withPartitionLoadBalancingStrategy(PartitionLoadBalancingStrategy loadBalancingStrategy) {
        if (loadBalancingStrategy == null) {
            throw new IllegalArgumentException("loadBalancingStrategy");
        }
        this.loadBalancingStrategy = loadBalancingStrategy;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl withPartitionProcessorFactory(PartitionProcessorFactory partitionProcessorFactory) {
        if (partitionProcessorFactory == null) {
            throw new IllegalArgumentException("partitionProcessorFactory");
        }
        this.partitionProcessorFactory = partitionProcessorFactory;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl withLeaseStoreManager(LeaseStoreManager leaseStoreManager) {
        if (leaseStoreManager == null) {
            throw new IllegalArgumentException("leaseStoreManager");
        }
        this.leaseStoreManager = leaseStoreManager;
        return this;
    }

    public ChangeFeedProcessorBuilderImpl withHealthMonitor(HealthMonitor healthMonitor) {
        if (healthMonitor == null) {
            throw new IllegalArgumentException("healthMonitor");
        }
        this.healthMonitor = healthMonitor;
        return this;
    }

    @Override
    public ChangeFeedProcessor build() {
        if (this.hostName == null) {
            throw new IllegalArgumentException("Host name was not specified");
        }
        if (this.observerFactory == null) {
            throw new IllegalArgumentException("Observer was not specified");
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.elastic();
        }
        return this;
    }

    public ChangeFeedProcessorBuilderImpl() {
        this.queryPartitionsMaxBatchSize = 100;
        this.degreeOfParallelism = 25;
    }

    public ChangeFeedProcessorBuilderImpl(PartitionManager partitionManager) {
        this.partitionManager = partitionManager;
    }

    private Mono<ChangeFeedProcessor> initializeCollectionPropertiesForBuild() {
        if (this.changeFeedProcessorOptions == null) {
            this.changeFeedProcessorOptions = new ChangeFeedProcessorOptions();
        }
        return this.feedContextClient.readDatabase(this.feedContextClient.getDatabaseClient(), null).map(databaseResourceResponse -> {
            this.databaseResourceId = databaseResourceResponse.getDatabase().getId();
            return this.databaseResourceId;
        }).flatMap(id -> this.feedContextClient.readContainer(this.feedContextClient.getContainerClient(), null).map(documentCollectionResourceResponse -> {
            this.collectionResourceId = documentCollectionResourceResponse.getContainer().getId();
            return this;
        }));
    }

    private Mono<LeaseStoreManager> getLeaseStoreManager() {
        if (this.leaseStoreManager == null) {
            return this.leaseContextClient.readContainerSettings(this.leaseContextClient.getContainerClient(), null).flatMap(collectionSettings -> {
                boolean isPartitioned;
                boolean bl = isPartitioned = collectionSettings.getPartitionKeyDefinition() != null && collectionSettings.getPartitionKeyDefinition().getPaths() != null && collectionSettings.getPartitionKeyDefinition().getPaths().size() > 0;
                if (!isPartitioned || collectionSettings.getPartitionKeyDefinition().getPaths().size() != 1 || !collectionSettings.getPartitionKeyDefinition().getPaths().get(0).equals("/id")) {
                    return Mono.error((Throwable)new IllegalArgumentException("The lease collection must have partition key equal to id."));
                }
                PartitionedByIdCollectionRequestOptionsFactory requestOptionsFactory = new PartitionedByIdCollectionRequestOptionsFactory();
                String leasePrefix = this.getLeasePrefix();
                return LeaseStoreManager.Builder().leasePrefix(leasePrefix).leaseCollectionLink(this.leaseContextClient.getContainerClient()).leaseContextClient(this.leaseContextClient).requestOptionsFactory(requestOptionsFactory).hostName(this.hostName).build().map(manager -> {
                    this.leaseStoreManager = manager;
                    return this.leaseStoreManager;
                });
            });
        }
        return Mono.just((Object)this.leaseStoreManager);
    }

    private String getLeasePrefix() {
        String optionsPrefix = this.changeFeedProcessorOptions.getLeasePrefix();
        if (optionsPrefix == null) {
            optionsPrefix = "";
        }
        URI uri = this.feedContextClient.getServiceEndpoint();
        return String.format("%s%s_%s_%s", optionsPrefix, uri.getHost(), this.databaseResourceId, this.collectionResourceId);
    }

    private Mono<PartitionManager> buildPartitionManager(LeaseStoreManager leaseStoreManager) {
        CheckpointerObserverFactory factory = new CheckpointerObserverFactory(this.observerFactory, new CheckpointFrequency());
        PartitionSynchronizerImpl synchronizer = new PartitionSynchronizerImpl(this.feedContextClient, this.feedContextClient.getContainerClient(), leaseStoreManager, leaseStoreManager, this.degreeOfParallelism, this.queryPartitionsMaxBatchSize);
        BootstrapperImpl bootstrapper = new BootstrapperImpl(synchronizer, leaseStoreManager, this.lockTime, this.sleepTime);
        PartitionSupervisorFactoryImpl partitionSupervisorFactory = new PartitionSupervisorFactoryImpl(factory, leaseStoreManager, this.partitionProcessorFactory != null ? this.partitionProcessorFactory : new PartitionProcessorFactoryImpl(this.feedContextClient, this.changeFeedProcessorOptions, leaseStoreManager, this.feedContextClient.getContainerClient()), this.changeFeedProcessorOptions, this.scheduler);
        if (this.loadBalancingStrategy == null) {
            this.loadBalancingStrategy = new EqualPartitionsBalancingStrategy(this.hostName, this.changeFeedProcessorOptions.getMinScaleCount(), this.changeFeedProcessorOptions.getMaxScaleCount(), this.changeFeedProcessorOptions.getLeaseExpirationInterval());
        }
        PartitionControllerImpl partitionController = new PartitionControllerImpl(leaseStoreManager, leaseStoreManager, partitionSupervisorFactory, synchronizer, this.scheduler);
        if (this.healthMonitor == null) {
            this.healthMonitor = new TraceHealthMonitor();
        }
        HealthMonitoringPartitionControllerDecorator partitionController2 = new HealthMonitoringPartitionControllerDecorator(partitionController, this.healthMonitor);
        PartitionLoadBalancerImpl partitionLoadBalancer = new PartitionLoadBalancerImpl(partitionController2, leaseStoreManager, this.loadBalancingStrategy, this.changeFeedProcessorOptions.getLeaseAcquireInterval(), this.scheduler);
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(bootstrapper, partitionController, partitionLoadBalancer);
        return Mono.just((Object)partitionManager);
    }

    @Override
    public void close() {
        this.stop().subscribeOn(Schedulers.elastic()).subscribe();
    }
}

