/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.ReplicationPolicy;
import com.azure.cosmos.models.ModelBridgeInternal;
import java.util.Map;

public class GatewayServiceConfigurationReader {
    private GlobalEndpointManager globalEndpointManager;

    public GatewayServiceConfigurationReader(GlobalEndpointManager globalEndpointManager) {
        this.globalEndpointManager = globalEndpointManager;
    }

    public ReplicationPolicy getUserReplicationPolicy() {
        return ModelBridgeInternal.getReplicationPolicy(this.globalEndpointManager.getLatestDatabaseAccount());
    }

    public ReplicationPolicy getSystemReplicationPolicy() {
        return ModelBridgeInternal.getSystemReplicationPolicy(this.globalEndpointManager.getLatestDatabaseAccount());
    }

    public ConsistencyLevel getDefaultConsistencyLevel() {
        return ModelBridgeInternal.getConsistencyPolicy(this.globalEndpointManager.getLatestDatabaseAccount()).getDefaultConsistencyLevel();
    }

    public Map<String, Object> getQueryEngineConfiguration() {
        return ModelBridgeInternal.getQueryEngineConfiuration(this.globalEndpointManager.getLatestDatabaseAccount());
    }
}

