/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BadRequestException;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.GatewayServiceConfigurationReader;

public class RequestHelper {
    public static ConsistencyLevel GetConsistencyLevelToUse(GatewayServiceConfigurationReader serviceConfigReader, RxDocumentServiceRequest request) throws CosmosClientException {
        ConsistencyLevel consistencyLevelToUse = serviceConfigReader.getDefaultConsistencyLevel();
        String requestConsistencyLevelHeaderValue = request.getHeaders().get("x-ms-consistency-level");
        if (!Strings.isNullOrEmpty(requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = ConsistencyLevel.fromServiceSerializedFormat(requestConsistencyLevelHeaderValue);
            if (requestConsistencyLevel == null) {
                throw new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level"));
            }
            consistencyLevelToUse = requestConsistencyLevel;
        }
        return consistencyLevelToUse;
    }
}

