/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.LifeCycleUtils;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.directconnectivity.HttpTransportClient;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SharedTransportClient
extends TransportClient {
    private static final Logger logger = LoggerFactory.getLogger(SharedTransportClient.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static SharedTransportClient sharedTransportClient;
    private final TransportClient transportClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransportClient getOrCreateInstance(Protocol protocol, Configs configs, Duration requestTimeout, UserAgentContainer userAgent) {
        Class<SharedTransportClient> clazz = SharedTransportClient.class;
        synchronized (SharedTransportClient.class) {
            if (sharedTransportClient == null) {
                assert (counter.get() == 0);
                logger.info("creating a new shared RntbdTransportClient");
                sharedTransportClient = new SharedTransportClient(protocol, configs, requestTimeout, userAgent);
            } else {
                logger.info("Reusing an instance of RntbdTransportClient");
            }
            counter.incrementAndGet();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return sharedTransportClient;
        }
    }

    private SharedTransportClient(Protocol protocol, Configs configs, Duration requestTimeout, UserAgentContainer userAgent) {
        if (protocol == Protocol.TCP) {
            this.transportClient = new RntbdTransportClient(configs, requestTimeout, userAgent);
        } else if (protocol == Protocol.HTTPS) {
            this.transportClient = new HttpTransportClient(configs, requestTimeout, userAgent);
        } else {
            throw new IllegalArgumentException(String.format("protocol: %s", new Object[]{protocol}));
        }
    }

    @Override
    protected Mono<StoreResponse> invokeStoreAsync(Uri physicalAddress, RxDocumentServiceRequest request) {
        return this.transportClient.invokeStoreAsync(physicalAddress, request);
    }

    public int getReferenceCounter() {
        return counter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Class<SharedTransportClient> clazz = SharedTransportClient.class;
        synchronized (SharedTransportClient.class) {
            int numberOfActiveTransportClients = counter.decrementAndGet();
            logger.info("closing one reference to the shared RntbdTransportClient, the number of remaining references is {}", (Object)numberOfActiveTransportClients);
            if (numberOfActiveTransportClients == 0) {
                logger.info("All references to shared RntbdTransportClient are closed. Closing the underlying RntbdTransportClient");
                LifeCycleUtils.closeQuietly(SharedTransportClient.sharedTransportClient.transportClient);
                sharedTransportClient = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

