/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.CosmosResponseDiagnostics;
import com.azure.cosmos.implementation.RequestTimeline;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResponse {
    static final Logger LOGGER = LoggerFactory.getLogger(StoreResponse.class);
    private final int status;
    private final String[] responseHeaderNames;
    private final String[] responseHeaderValues;
    private final byte[] content;
    private CosmosResponseDiagnostics cosmosResponseDiagnostics;
    private RequestTimeline requestTimeline = RequestTimeline.empty();

    public StoreResponse(int status, List<Map.Entry<String, String>> headerEntries, byte[] content) {
        this.responseHeaderNames = new String[headerEntries.size()];
        this.responseHeaderValues = new String[headerEntries.size()];
        int i = 0;
        for (Map.Entry<String, String> headerEntry : headerEntries) {
            this.responseHeaderNames[i] = headerEntry.getKey();
            this.responseHeaderValues[i] = headerEntry.getValue();
            ++i;
        }
        this.status = status;
        this.content = content;
    }

    public int getStatus() {
        return this.status;
    }

    public String[] getResponseHeaderNames() {
        return this.responseHeaderNames;
    }

    public String[] getResponseHeaderValues() {
        return this.responseHeaderValues;
    }

    public byte[] getResponseBody() {
        return this.content;
    }

    public long getLSN() {
        String lsnString = this.getHeaderValue("lsn");
        if (StringUtils.isNotEmpty((CharSequence)lsnString)) {
            return Long.parseLong(lsnString);
        }
        return -1L;
    }

    public String getPartitionKeyRangeId() {
        return this.getHeaderValue("x-ms-documentdb-partitionkeyrangeid");
    }

    public String getContinuation() {
        return this.getHeaderValue("x-ms-continuation");
    }

    public String getHeaderValue(String attribute) {
        if (this.responseHeaderValues == null || this.responseHeaderNames.length != this.responseHeaderValues.length) {
            return null;
        }
        for (int i = 0; i < this.responseHeaderNames.length; ++i) {
            if (!this.responseHeaderNames[i].equalsIgnoreCase(attribute)) continue;
            return this.responseHeaderValues[i];
        }
        return null;
    }

    public CosmosResponseDiagnostics getCosmosResponseDiagnostics() {
        return this.cosmosResponseDiagnostics;
    }

    StoreResponse setCosmosResponseDiagnostics(CosmosResponseDiagnostics cosmosResponseDiagnostics) {
        this.cosmosResponseDiagnostics = cosmosResponseDiagnostics;
        return this;
    }

    void setRequestTimeline(RequestTimeline requestTimeline) {
        this.requestTimeline = requestTimeline;
    }

    RequestTimeline getRequestTimeline() {
        return this.requestTimeline;
    }

    int getSubStatusCode() {
        int subStatusCode = 0;
        String subStatusCodeString = this.getHeaderValue("x-ms-substatus");
        if (StringUtils.isNotEmpty((CharSequence)subStatusCodeString)) {
            try {
                subStatusCode = Integer.parseInt(subStatusCodeString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return subStatusCode;
    }
}

