/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.guava27.Strings;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;

final class RntbdFramer {
    private RntbdFramer() {
    }

    static boolean canDecodeHead(ByteBuf in) throws CorruptedFrameException {
        Preconditions.checkNotNull((Object)in, (Object)"in");
        if (in.readableBytes() < 24) {
            return false;
        }
        int start = in.readerIndex();
        long length = in.getUnsignedIntLE(start);
        if (length > Integer.MAX_VALUE) {
            String reason = Strings.lenientFormat("Head frame length exceeds Integer.MAX_VALUE, %s: %s", Integer.MAX_VALUE, length);
            throw new CorruptedFrameException(reason);
        }
        if (length < 4L) {
            String reason = Strings.lenientFormat("Head frame length is less than size of length field, %s: %s", 4, length);
            throw new CorruptedFrameException(reason);
        }
        return length <= (long)in.readableBytes();
    }

    static boolean canDecodePayload(ByteBuf in, int start) {
        Preconditions.checkNotNull((Object)in, (Object)"in");
        int readerIndex = in.readerIndex();
        if (start < readerIndex) {
            throw new IllegalArgumentException("start < in.readerIndex()");
        }
        int offset = start - readerIndex;
        if (in.readableBytes() - offset < 4) {
            return false;
        }
        long length = in.getUnsignedIntLE(start);
        if (length > Integer.MAX_VALUE) {
            String reason = Strings.lenientFormat("Payload frame length exceeds Integer.MAX_VALUE, %s: %s", Integer.MAX_VALUE, length);
            throw new CorruptedFrameException(reason);
        }
        return (long)(offset + 4) + length <= (long)in.readableBytes();
    }

    static boolean canDecodePayload(ByteBuf in) {
        return RntbdFramer.canDecodePayload(in, in.readerIndex());
    }
}

