/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.routing.Range;
import com.azure.cosmos.models.JsonSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeContinuationToken
extends JsonSerializable {
    private static final String TokenPropertyName = "token";
    private static final String RangePropertyName = "range";
    private static final Logger logger = LoggerFactory.getLogger(CompositeContinuationToken.class);

    public CompositeContinuationToken(String token, Range<String> range) {
        if (range == null) {
            throw new IllegalArgumentException("range must not be null.");
        }
        this.setToken(token);
        this.setRange(range);
    }

    private CompositeContinuationToken(String serializedCompositeContinuationToken) {
        super(serializedCompositeContinuationToken);
    }

    public static boolean tryParse(String serializedCompositeContinuationToken, Utils.ValueHolder<CompositeContinuationToken> outCompositeContinuationToken) {
        boolean parsed;
        try {
            CompositeContinuationToken compositeContinuationToken = new CompositeContinuationToken(serializedCompositeContinuationToken);
            compositeContinuationToken.getToken();
            Range<String> range = compositeContinuationToken.getRange();
            if (range == null) {
                throw new IllegalArgumentException("range must not be null.");
            }
            range.getMax();
            range.getMin();
            range.isEmpty();
            range.isMaxInclusive();
            range.isMinInclusive();
            range.isSingleValue();
            outCompositeContinuationToken.v = compositeContinuationToken;
            parsed = true;
        }
        catch (Exception ex) {
            logger.debug("Received exception {} when trying to parse: {}", (Object)ex.getMessage(), (Object)serializedCompositeContinuationToken);
            parsed = false;
            outCompositeContinuationToken.v = null;
        }
        return parsed;
    }

    public String getToken() {
        return super.getString(TokenPropertyName);
    }

    public Range<String> getRange() {
        return new Range<String>(super.getString(RangePropertyName));
    }

    private void setToken(String token) {
        BridgeInternal.setProperty(this, TokenPropertyName, token);
    }

    private void setRange(Range<String> range) {
        BridgeInternal.setProperty(this, RangePropertyName, range.toString());
    }
}

