/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.BadRequestException;
import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.implementation.QueryMetrics;
import com.azure.cosmos.implementation.RequestChargeTracker;
import com.azure.cosmos.implementation.ResourceId;
import com.azure.cosmos.implementation.query.DocumentProducer;
import com.azure.cosmos.implementation.query.ItemComparator;
import com.azure.cosmos.implementation.query.OrderByContinuationToken;
import com.azure.cosmos.implementation.query.QueryItem;
import com.azure.cosmos.implementation.query.SortOrder;
import com.azure.cosmos.implementation.query.orderbyquery.OrderByRowResult;
import com.azure.cosmos.implementation.query.orderbyquery.OrderbyRowComparer;
import com.azure.cosmos.models.Resource;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class OrderByUtils {
    OrderByUtils() {
    }

    public static <T extends Resource> Flux<OrderByRowResult<T>> orderedMerge(Class<T> klass, OrderbyRowComparer<T> consumeComparer, RequestChargeTracker tracker, List<DocumentProducer<T>> documentProducers, Map<String, QueryMetrics> queryMetricsMap, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap) {
        Flux[] fluxes = (Flux[])documentProducers.subList(0, documentProducers.size()).stream().map(producer -> OrderByUtils.toOrderByQueryResultObservable(klass, producer, tracker, queryMetricsMap, targetRangeToOrderByContinuationTokenMap, consumeComparer.getSortOrders())).toArray(Flux[]::new);
        return Flux.mergeOrdered(consumeComparer, (Publisher[])fluxes);
    }

    private static <T extends Resource> Flux<OrderByRowResult<T>> toOrderByQueryResultObservable(Class<T> klass, DocumentProducer<T> producer, RequestChargeTracker tracker, Map<String, QueryMetrics> queryMetricsMap, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap, List<SortOrder> sortOrders) {
        return producer.produceAsync().compose(new PageToItemTransformer<T>(klass, tracker, queryMetricsMap, targetRangeToOrderByContinuationTokenMap, sortOrders));
    }

    private static class PageToItemTransformer<T extends Resource>
    implements Function<Flux<DocumentProducer.DocumentProducerFeedResponse>, Flux<OrderByRowResult<T>>> {
        private final RequestChargeTracker tracker;
        private final Class<T> klass;
        private final Map<String, QueryMetrics> queryMetricsMap;
        private final Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap;
        private final List<SortOrder> sortOrders;

        public PageToItemTransformer(Class<T> klass, RequestChargeTracker tracker, Map<String, QueryMetrics> queryMetricsMap, Map<String, OrderByContinuationToken> targetRangeToOrderByContinuationTokenMap, List<SortOrder> sortOrders) {
            this.klass = klass;
            this.tracker = tracker;
            this.queryMetricsMap = queryMetricsMap;
            this.targetRangeToOrderByContinuationTokenMap = targetRangeToOrderByContinuationTokenMap;
            this.sortOrders = sortOrders;
        }

        @Override
        public Flux<OrderByRowResult<T>> apply(Flux<DocumentProducer.DocumentProducerFeedResponse> source) {
            return source.flatMap(documentProducerFeedResponse -> {
                for (String key : BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult).keySet()) {
                    if (this.queryMetricsMap.containsKey(key)) {
                        QueryMetrics qm = (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult).get(key);
                        this.queryMetricsMap.get(key).add(qm);
                        continue;
                    }
                    this.queryMetricsMap.put(key, (QueryMetrics)BridgeInternal.queryMetricsFromFeedResponse(documentProducerFeedResponse.pageResult).get(key));
                }
                List results = documentProducerFeedResponse.pageResult.getResults();
                OrderByContinuationToken orderByContinuationToken = this.targetRangeToOrderByContinuationTokenMap.get(documentProducerFeedResponse.sourcePartitionKeyRange.getId());
                if (orderByContinuationToken != null) {
                    Pair<Boolean, ResourceId> booleanResourceIdPair = ResourceId.tryParse(orderByContinuationToken.getRid());
                    if (!((Boolean)booleanResourceIdPair.getLeft()).booleanValue()) {
                        return Flux.error((Throwable)new BadRequestException(String.format("INVALID Rid in the continuation token %s for OrderBy~Context.", orderByContinuationToken.getCompositeContinuationToken().getToken())));
                    }
                    ResourceId continuationTokenRid = (ResourceId)booleanResourceIdPair.getRight();
                    results = results.stream().filter(tOrderByRowResult -> {
                        ArrayList<QueryItem> queryItems = new ArrayList<QueryItem>();
                        ArrayNode arrayNode = (ArrayNode)tOrderByRowResult.get("orderByItems");
                        for (JsonNode jsonNode : arrayNode) {
                            QueryItem queryItem = new QueryItem(jsonNode.toString());
                            queryItems.add(queryItem);
                        }
                        long cmp = 0L;
                        for (int i = 0; i < this.sortOrders.size(); ++i) {
                            cmp = ItemComparator.getInstance().compare(orderByContinuationToken.getOrderByItems()[i].getItem(), ((QueryItem)queryItems.get(i)).getItem());
                            if (cmp == 0L) continue;
                            cmp = this.sortOrders.get(i).equals((Object)SortOrder.Descending) ? -cmp : cmp;
                            break;
                        }
                        if (cmp == 0L) {
                            cmp = continuationTokenRid.getDocument() - ((ResourceId)ResourceId.tryParse(tOrderByRowResult.getResourceId()).getRight()).getDocument();
                            if (this.sortOrders.iterator().next().equals((Object)SortOrder.Descending)) {
                                cmp = -cmp;
                            }
                            return cmp <= 0L;
                        }
                        return true;
                    }).collect(Collectors.toList());
                }
                this.tracker.addCharge(documentProducerFeedResponse.pageResult.getRequestCharge());
                Flux x = Flux.fromIterable(results);
                return x.map(r -> new OrderByRowResult<T>(this.klass, r.toJson(), documentProducerFeedResponse.sourcePartitionKeyRange, documentProducerFeedResponse.pageResult.getContinuationToken()));
            }, 1);
        }
    }
}

