/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.metrics;

import com.azure.cosmos.implementation.query.metrics.FetchExecutionRange;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;

public class FetchExecutionRangeAccumulator {
    private final String partitionKeyRangeId;
    private final Instant constructionTime;
    private final StopWatch stopwatch;
    private List<FetchExecutionRange> fetchExecutionRanges;
    private Instant startTime;
    private Instant endTime;
    private boolean isFetching;

    public FetchExecutionRangeAccumulator(String partitionKeyRangeId) {
        this.partitionKeyRangeId = partitionKeyRangeId;
        this.constructionTime = Instant.now();
        this.stopwatch = new StopWatch();
        this.stopwatch.start();
        this.fetchExecutionRanges = new ArrayList<FetchExecutionRange>();
    }

    public List<FetchExecutionRange> getExecutionRanges() {
        List<FetchExecutionRange> returnValue = this.fetchExecutionRanges;
        this.fetchExecutionRanges = new ArrayList<FetchExecutionRange>();
        return returnValue;
    }

    public void beginFetchRange() {
        if (!this.isFetching) {
            this.startTime = this.constructionTime.plus(Duration.ofMillis(this.stopwatch.getTime(TimeUnit.MILLISECONDS)));
            this.isFetching = true;
        }
    }

    public void endFetchRange(String activityId, long numberOfDocuments, long retryCount) {
        if (this.isFetching) {
            this.endTime = this.constructionTime.plus(Duration.ofMillis(this.stopwatch.getTime(TimeUnit.MILLISECONDS)));
            FetchExecutionRange fetchExecutionRange = new FetchExecutionRange(activityId, this.startTime, this.endTime, this.partitionKeyRangeId, numberOfDocuments, retryCount);
            this.fetchExecutionRanges.add(fetchExecutionRange);
            this.isFetching = false;
        }
    }
}

