/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.models.CosmosContainerProperties;
import com.azure.cosmos.models.CosmosResponse;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncContainerResponse
extends CosmosResponse<CosmosContainerProperties> {
    private final CosmosAsyncContainer container;

    CosmosAsyncContainerResponse(ResourceResponse<DocumentCollection> response, CosmosAsyncDatabase database) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            super.setProperties(null);
            this.container = null;
        } else {
            CosmosContainerProperties props = new CosmosContainerProperties(bodyAsString);
            super.setProperties(props);
            this.container = BridgeInternal.createCosmosAsyncContainer(this.getProperties().getId(), database);
        }
    }

    public long getIndexTransformationProgress() {
        return this.resourceResponseWrapper.getIndexTransformationProgress();
    }

    long getLazyIndexingProgress() {
        return this.resourceResponseWrapper.getLazyIndexingProgress();
    }

    @Override
    public CosmosContainerProperties getProperties() {
        return (CosmosContainerProperties)super.getProperties();
    }

    public CosmosAsyncContainer getContainer() {
        return this.container;
    }
}

