/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.implementation.Database;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.models.CosmosDatabaseProperties;
import com.azure.cosmos.models.CosmosResponse;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncDatabaseResponse
extends CosmosResponse<CosmosDatabaseProperties> {
    private final CosmosAsyncDatabase database;

    CosmosAsyncDatabaseResponse(ResourceResponse<Database> response, CosmosAsyncClient client) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            super.setProperties(null);
            this.database = null;
        } else {
            CosmosDatabaseProperties props = new CosmosDatabaseProperties(bodyAsString, null);
            super.setProperties(props);
            this.database = BridgeInternal.createCosmosAsyncDatabase(props.getId(), client);
        }
    }

    public CosmosAsyncDatabase getDatabase() {
        return this.database;
    }

    @Override
    public CosmosDatabaseProperties getProperties() {
        return (CosmosDatabaseProperties)super.getProperties();
    }

    public long getDatabaseQuota() {
        return this.resourceResponseWrapper.getDatabaseQuota();
    }

    public long getDatabaseUsage() {
        return this.resourceResponseWrapper.getDatabaseUsage();
    }
}

