/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncPermission;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.Permission;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncPermissionResponse
extends CosmosResponse<CosmosPermissionProperties> {
    private final CosmosAsyncPermission permissionClient;

    CosmosAsyncPermissionResponse(ResourceResponse<Permission> response, CosmosAsyncUser cosmosUser) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            super.setProperties(null);
            this.permissionClient = null;
        } else {
            CosmosPermissionProperties props = new CosmosPermissionProperties(bodyAsString);
            super.setProperties(props);
            this.permissionClient = BridgeInternal.createCosmosAsyncPermission(props.getId(), cosmosUser);
        }
    }

    @Override
    public CosmosPermissionProperties getProperties() {
        return (CosmosPermissionProperties)super.getProperties();
    }

    public CosmosAsyncPermission getPermission() {
        return this.permissionClient;
    }
}

