/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.CosmosAsyncUserDefinedFunction;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncUserDefinedFunctionResponse
extends CosmosResponse<CosmosUserDefinedFunctionProperties> {
    private final CosmosUserDefinedFunctionProperties cosmosUserDefinedFunctionProperties;
    private final CosmosAsyncUserDefinedFunction cosmosUserDefinedFunction;

    CosmosAsyncUserDefinedFunctionResponse(ResourceResponse<UserDefinedFunction> response, CosmosAsyncContainer container) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            this.cosmosUserDefinedFunctionProperties = null;
            this.cosmosUserDefinedFunction = null;
        } else {
            this.cosmosUserDefinedFunctionProperties = new CosmosUserDefinedFunctionProperties(bodyAsString);
            super.setProperties(this.cosmosUserDefinedFunctionProperties);
            this.cosmosUserDefinedFunction = BridgeInternal.createCosmosAsyncUserDefinedFunction(this.cosmosUserDefinedFunctionProperties.getId(), container);
        }
    }

    @Override
    public CosmosUserDefinedFunctionProperties getProperties() {
        return this.cosmosUserDefinedFunctionProperties;
    }

    public CosmosAsyncUserDefinedFunction getUserDefinedFunction() {
        return this.cosmosUserDefinedFunction;
    }
}

