/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.CosmosAsyncDatabase;
import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.implementation.ResourceResponse;
import com.azure.cosmos.implementation.User;
import com.azure.cosmos.models.CosmosResponse;
import com.azure.cosmos.models.CosmosUserProperties;
import org.apache.commons.lang3.StringUtils;

public class CosmosAsyncUserResponse
extends CosmosResponse<CosmosUserProperties> {
    private final CosmosAsyncUser user;

    CosmosAsyncUserResponse(ResourceResponse<User> response, CosmosAsyncDatabase database) {
        super(response);
        String bodyAsString = response.getBodyAsString();
        if (StringUtils.isEmpty((CharSequence)bodyAsString)) {
            super.setProperties(null);
            this.user = null;
        } else {
            CosmosUserProperties props = new CosmosUserProperties(bodyAsString);
            super.setProperties(props);
            this.user = BridgeInternal.createCosmosAsyncUser(props.getId(), database);
        }
    }

    public CosmosAsyncUser getUser() {
        return this.user;
    }

    @Override
    public CosmosUserProperties getProperties() {
        return (CosmosUserProperties)super.getProperties();
    }
}

