/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.models.Permission;
import com.azure.cosmos.models.PermissionMode;
import com.azure.cosmos.models.Resource;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CosmosPermissionProperties
extends Resource {
    static List<CosmosPermissionProperties> getFromV2Results(List<Permission> results) {
        return results.stream().map(permission -> new CosmosPermissionProperties(permission.toJson())).collect(Collectors.toList());
    }

    public CosmosPermissionProperties() {
    }

    @Override
    public CosmosPermissionProperties setId(String id) {
        super.setId(id);
        return this;
    }

    CosmosPermissionProperties(String jsonString) {
        super(jsonString);
    }

    public String getResourceLink() {
        return super.getString("resource");
    }

    public CosmosPermissionProperties setResourceLink(String resourceLink) {
        super.set("resource", resourceLink);
        return this;
    }

    public PermissionMode getPermissionMode() {
        String value = super.getString("permissionMode");
        return PermissionMode.valueOf(StringUtils.upperCase((String)value));
    }

    public CosmosPermissionProperties setPermissionMode(PermissionMode permissionMode) {
        this.set("permissionMode", permissionMode.toString().toLowerCase());
        return this;
    }

    public CosmosPermissionProperties setResourcePartitionKey(PartitionKey partitionKey) {
        super.set("resourcePartitionKey", BridgeInternal.getPartitionKeyInternal(partitionKey).toJson());
        return this;
    }

    Permission getV2Permissions() {
        return new Permission(this.toJson());
    }
}

