/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.HashIndex;
import com.azure.cosmos.models.Index;
import com.azure.cosmos.models.IndexKind;
import com.azure.cosmos.models.JsonSerializable;
import com.azure.cosmos.models.RangeIndex;
import com.azure.cosmos.models.SpatialIndex;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class IncludedPath
extends JsonSerializable {
    private Collection<Index> indexes;

    public IncludedPath() {
    }

    public IncludedPath(String jsonString) {
        super(jsonString);
    }

    public String getPath() {
        return super.getString("path");
    }

    public IncludedPath setPath(String path) {
        super.set("path", path);
        return this;
    }

    public Collection<Index> getIndexes() {
        if (this.indexes == null) {
            this.indexes = this.getIndexCollection();
            if (this.indexes == null) {
                this.indexes = new ArrayList<Index>();
            }
        }
        return this.indexes;
    }

    public IncludedPath setIndexes(Collection<Index> indexes) {
        this.indexes = indexes;
        return this;
    }

    private Collection<Index> getIndexCollection() {
        if (this.getPropertyBag() != null && this.getPropertyBag().has("indexes")) {
            ArrayNode jsonArray = (ArrayNode)this.getPropertyBag().get("indexes");
            ArrayList<Index> result = new ArrayList<Index>();
            block5: for (int i = 0; i < jsonArray.size(); ++i) {
                JsonNode jsonObject = jsonArray.get(i);
                IndexKind indexKind = IndexKind.valueOf(StringUtils.upperCase((String)jsonObject.get("kind").asText()));
                switch (indexKind) {
                    case HASH: {
                        result.add(new HashIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case RANGE: {
                        result.add(new RangeIndex(jsonObject.toString()));
                        continue block5;
                    }
                    case SPATIAL: {
                        result.add(new SpatialIndex(jsonObject.toString()));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + (Object)((Object)indexKind));
                    }
                }
            }
            return result;
        }
        return null;
    }

    @Override
    protected void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.indexes != null) {
            for (Index index : this.indexes) {
                index.populatePropertyBag();
            }
            super.set("indexes", this.indexes);
        }
    }
}

