/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.models.JsonSerializable;
import com.azure.cosmos.models.PartitionKeyDefinitionVersion;
import com.azure.cosmos.models.PartitionKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public final class PartitionKeyDefinition
extends JsonSerializable {
    private List<String> paths;
    private PartitionKind kind;
    private Optional<PartitionKeyDefinitionVersion> versionOptional;
    private Boolean systemKey;

    public PartitionKeyDefinition() {
        this.setKind(PartitionKind.HASH);
    }

    PartitionKeyDefinition(String jsonString) {
        super(jsonString);
    }

    public PartitionKind getKind() {
        if (this.kind == null) {
            this.kind = super.getObject("kind", PartitionKind.class, true);
        }
        return this.kind;
    }

    public PartitionKeyDefinition setKind(PartitionKind kind) {
        this.kind = kind;
        return this;
    }

    public PartitionKeyDefinitionVersion getVersion() {
        if (this.versionOptional == null) {
            Object versionObject = super.getObject("version", Object.class, new boolean[0]);
            if (versionObject == null) {
                this.versionOptional = Optional.empty();
            } else {
                String versionStr = String.valueOf(versionObject);
                if (StringUtils.isNumeric((CharSequence)versionStr)) {
                    this.versionOptional = Optional.of(PartitionKeyDefinitionVersion.valueOf(String.format("V%d", Integer.parseInt(versionStr))));
                } else {
                    Optional<Object> optional = this.versionOptional = !Strings.isNullOrEmpty(versionStr) ? Optional.of(PartitionKeyDefinitionVersion.valueOf(StringUtils.upperCase((String)versionStr))) : Optional.empty();
                }
            }
            assert (this.versionOptional != null);
        }
        return this.versionOptional.isPresent() ? this.versionOptional.get() : null;
    }

    public PartitionKeyDefinition setVersion(PartitionKeyDefinitionVersion version) {
        this.versionOptional = Optional.of(version);
        return this;
    }

    public List<String> getPaths() {
        if (this.paths == null) {
            this.paths = super.has("paths") ? super.getList("paths", String.class, new boolean[0]) : new ArrayList<String>();
        }
        return this.paths;
    }

    public PartitionKeyDefinition setPaths(List<String> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("getPaths must not be null or empty.");
        }
        this.paths = paths;
        return this;
    }

    Boolean isSystemKey() {
        if (this.systemKey == null) {
            this.systemKey = super.has("systemKey") ? super.getBoolean("systemKey") : Boolean.valueOf(false);
        }
        return this.systemKey;
    }

    PartitionKeyInternal getNonePartitionKeyValue() {
        if (this.getPaths().size() == 0 || this.isSystemKey().booleanValue()) {
            return PartitionKeyInternal.Empty;
        }
        return PartitionKeyInternal.UndefinedPartitionKey;
    }

    @Override
    protected void populatePropertyBag() {
        super.populatePropertyBag();
        if (this.kind != null) {
            super.set("kind", this.kind.toString());
        }
        if (this.paths != null) {
            super.set("paths", this.paths);
        }
        if (this.versionOptional != null && this.versionOptional.isPresent()) {
            super.set("version", this.versionOptional.get().toString());
        }
    }
}

