/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.models.JsonSerializable;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlParameterList;
import java.util.ArrayList;
import java.util.Collection;

public final class SqlQuerySpec
extends JsonSerializable {
    private SqlParameterList parameters;

    public SqlQuerySpec() {
    }

    public SqlQuerySpec(String queryText) {
        this.setQueryText(queryText);
    }

    public SqlQuerySpec(String queryText, SqlParameterList parameters) {
        this.setQueryText(queryText);
        this.parameters = parameters;
    }

    public String getQueryText() {
        return super.getString("query");
    }

    public SqlQuerySpec setQueryText(String queryText) {
        super.set("query", queryText);
        return this;
    }

    public SqlParameterList getParameters() {
        if (this.parameters == null) {
            Collection<SqlParameter> sqlParameters = super.getCollection("parameters", SqlParameter.class, new boolean[0]);
            if (sqlParameters == null) {
                sqlParameters = new ArrayList<SqlParameter>();
            }
            this.parameters = new SqlParameterList(sqlParameters);
        }
        return this.parameters;
    }

    public SqlQuerySpec setParameters(SqlParameterList parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    protected void populatePropertyBag() {
        boolean defaultParameters;
        super.populatePropertyBag();
        boolean bl = defaultParameters = this.parameters != null && this.parameters.size() != 0;
        if (defaultParameters) {
            super.set("parameters", this.parameters);
        } else {
            super.remove("parameters");
        }
    }
}

