/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.ConnectionMode;
import com.azure.cosmos.ThrottlingRetryOptions;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;

public final class ConnectionPolicy {
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_MEDIA_REQUEST_TIMEOUT = Duration.ofSeconds(300L);
    private static final Duration DEFAULT_IDLE_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final int DEFAULT_MAX_POOL_SIZE = 1000;
    private static ConnectionPolicy defaultPolicy = null;
    private Duration requestTimeout;
    private final Duration mediaRequestTimeout;
    private ConnectionMode connectionMode = ConnectionMode.DIRECT;
    private int maxPoolSize = 1000;
    private Duration idleConnectionTimeout = DEFAULT_IDLE_CONNECTION_TIMEOUT;
    private String userAgentSuffix = "";
    private ThrottlingRetryOptions throttlingRetryOptions;
    private boolean endpointDiscoveryEnabled = true;
    private List<String> preferredLocations;
    private boolean usingMultipleWriteLocations = true;
    private InetSocketAddress inetSocketProxyAddress;
    private Boolean readRequestsFallbackEnabled = null;

    public ConnectionPolicy() {
        this.mediaRequestTimeout = DEFAULT_MEDIA_REQUEST_TIMEOUT;
        this.requestTimeout = DEFAULT_REQUEST_TIMEOUT;
        this.throttlingRetryOptions = new ThrottlingRetryOptions();
    }

    public static ConnectionPolicy getDefaultPolicy() {
        if (defaultPolicy == null) {
            defaultPolicy = new ConnectionPolicy();
        }
        return defaultPolicy;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public ConnectionPolicy setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ConnectionPolicy setConnectionMode(ConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public ConnectionPolicy setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        return this;
    }

    public Duration getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    public ConnectionPolicy setIdleConnectionTimeout(Duration idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
        return this;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    public ConnectionPolicy setUserAgentSuffix(String userAgentSuffix) {
        this.userAgentSuffix = userAgentSuffix;
        return this;
    }

    public ThrottlingRetryOptions getThrottlingRetryOptions() {
        return this.throttlingRetryOptions;
    }

    public ConnectionPolicy setThrottlingRetryOptions(ThrottlingRetryOptions throttlingRetryOptions) {
        if (throttlingRetryOptions == null) {
            throw new IllegalArgumentException("retryOptions value must not be null.");
        }
        this.throttlingRetryOptions = throttlingRetryOptions;
        return this;
    }

    public boolean isEndpointDiscoveryEnabled() {
        return this.endpointDiscoveryEnabled;
    }

    public ConnectionPolicy setEndpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    public boolean isUsingMultipleWriteLocations() {
        return this.usingMultipleWriteLocations;
    }

    public Boolean isReadRequestsFallbackEnabled() {
        return this.readRequestsFallbackEnabled;
    }

    public ConnectionPolicy setUsingMultipleWriteLocations(boolean usingMultipleWriteLocations) {
        this.usingMultipleWriteLocations = usingMultipleWriteLocations;
        return this;
    }

    public ConnectionPolicy setReadRequestsFallbackEnabled(Boolean readRequestsFallbackEnabled) {
        this.readRequestsFallbackEnabled = readRequestsFallbackEnabled;
        return this;
    }

    public List<String> getPreferredLocations() {
        return this.preferredLocations != null ? this.preferredLocations : Collections.emptyList();
    }

    public ConnectionPolicy setPreferredLocations(List<String> preferredLocations) {
        this.preferredLocations = preferredLocations;
        return this;
    }

    public InetSocketAddress getProxy() {
        return this.inetSocketProxyAddress;
    }

    public ConnectionPolicy setProxy(InetSocketAddress proxy) {
        this.inetSocketProxyAddress = proxy;
        return this;
    }

    public String toString() {
        return "ConnectionPolicy{requestTimeout=" + this.requestTimeout + ", mediaRequestTimeout=" + this.mediaRequestTimeout + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", maxPoolSize=" + this.maxPoolSize + ", idleConnectionTimeout=" + this.idleConnectionTimeout + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", retryOptions=" + this.throttlingRetryOptions + ", enableEndpointDiscovery=" + this.endpointDiscoveryEnabled + ", preferredLocations=" + this.preferredLocations + ", usingMultipleWriteLocations=" + this.usingMultipleWriteLocations + ", inetSocketProxyAddress=" + this.inetSocketProxyAddress + '}';
    }
}

