/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncUser;
import com.azure.cosmos.models.CosmosAsyncPermissionResponse;
import com.azure.cosmos.models.CosmosPermissionProperties;
import com.azure.cosmos.models.CosmosPermissionRequestOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncPermission {
    private final CosmosAsyncUser cosmosUser;
    private String id;

    CosmosAsyncPermission(String id, CosmosAsyncUser user) {
        this.id = id;
        this.cosmosUser = user;
    }

    public String id() {
        return this.id;
    }

    CosmosAsyncPermission id(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncPermissionResponse> read(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.cosmosUser.getDatabase().getDocClientWrapper().readPermission(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncPermissionResponse(response, this.cosmosUser)).single();
    }

    public Mono<CosmosAsyncPermissionResponse> replace(CosmosPermissionProperties permissionSettings, CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.cosmosUser.getDatabase().getDocClientWrapper().replacePermission(ModelBridgeInternal.getV2Permissions(permissionSettings), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncPermissionResponse(response, this.cosmosUser)).single();
    }

    public Mono<CosmosAsyncPermissionResponse> delete(CosmosPermissionRequestOptions options) {
        if (options == null) {
            options = new CosmosPermissionRequestOptions();
        }
        return this.cosmosUser.getDatabase().getDocClientWrapper().deletePermission(this.getLink(), ModelBridgeInternal.toRequestOptions(options)).map(response -> ModelBridgeInternal.createCosmosAsyncPermissionResponse(response, this.cosmosUser)).single();
    }

    String getURIPathSegment() {
        return "permissions";
    }

    String getParentLink() {
        return this.cosmosUser.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.id());
        return builder.toString();
    }
}

