/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncContainer;
import com.azure.cosmos.implementation.UserDefinedFunction;
import com.azure.cosmos.models.CosmosAsyncUserDefinedFunctionResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.ModelBridgeInternal;
import reactor.core.publisher.Mono;

public class CosmosAsyncUserDefinedFunction {
    private final CosmosAsyncContainer container;
    private String id;

    CosmosAsyncUserDefinedFunction(String id, CosmosAsyncContainer container) {
        this.id = id;
        this.container = container;
    }

    public String getId() {
        return this.id;
    }

    CosmosAsyncUserDefinedFunction setId(String id) {
        this.id = id;
        return this;
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> read() {
        return this.container.getDatabase().getDocClientWrapper().readUserDefinedFunction(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosAsyncUserDefinedFunctionResponse(response, this.container)).single();
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> replace(CosmosUserDefinedFunctionProperties udfSettings) {
        return this.container.getDatabase().getDocClientWrapper().replaceUserDefinedFunction(new UserDefinedFunction(ModelBridgeInternal.toJsonFromJsonSerializable(udfSettings)), null).map(response -> ModelBridgeInternal.createCosmosAsyncUserDefinedFunctionResponse(response, this.container)).single();
    }

    public Mono<CosmosAsyncUserDefinedFunctionResponse> delete() {
        return this.container.getDatabase().getDocClientWrapper().deleteUserDefinedFunction(this.getLink(), null).map(response -> ModelBridgeInternal.createCosmosAsyncUserDefinedFunctionResponse(response, this.container)).single();
    }

    String getURIPathSegment() {
        return "udfs";
    }

    String getParentLink() {
        return this.container.getLink();
    }

    String getLink() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getParentLink());
        builder.append("/");
        builder.append(this.getURIPathSegment());
        builder.append("/");
        builder.append(this.getId());
        return builder.toString();
    }
}

