/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.cosmos.ConnectionPolicy;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosAuthorizationTokenResolver;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosKeyCredential;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.CosmosPermissionProperties;
import java.util.List;

@ServiceClientBuilder(serviceClients={CosmosClient.class, CosmosAsyncClient.class})
public class CosmosClientBuilder {
    private Configs configs = new Configs();
    private String serviceEndpoint;
    private String keyOrResourceToken;
    private ConnectionPolicy connectionPolicy;
    private ConsistencyLevel desiredConsistencyLevel;
    private List<CosmosPermissionProperties> permissions;
    private CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver;
    private CosmosKeyCredential cosmosKeyCredential;
    private boolean sessionCapturingOverrideEnabled;
    private boolean connectionReuseAcrossClientsEnabled;

    public CosmosClientBuilder sessionCapturingOverrideEnabled(boolean sessionCapturingOverrideEnabled) {
        this.sessionCapturingOverrideEnabled = sessionCapturingOverrideEnabled;
        return this;
    }

    boolean isSessionCapturingOverrideEnabled() {
        return this.sessionCapturingOverrideEnabled;
    }

    public CosmosClientBuilder connectionReuseAcrossClientsEnabled(boolean connectionReuseAcrossClientsEnabled) {
        this.connectionReuseAcrossClientsEnabled = true;
        return this;
    }

    boolean isConnectionReuseAcrossClientsEnabled() {
        return this.connectionReuseAcrossClientsEnabled;
    }

    CosmosAuthorizationTokenResolver getAuthorizationTokenResolver() {
        return this.cosmosAuthorizationTokenResolver;
    }

    public CosmosClientBuilder authorizationTokenResolver(CosmosAuthorizationTokenResolver cosmosAuthorizationTokenResolver) {
        this.cosmosAuthorizationTokenResolver = cosmosAuthorizationTokenResolver;
        return this;
    }

    String getEndpoint() {
        return this.serviceEndpoint;
    }

    public CosmosClientBuilder endpoint(String endpoint) {
        this.serviceEndpoint = endpoint;
        return this;
    }

    String getKey() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder key(String key) {
        this.keyOrResourceToken = key;
        return this;
    }

    String getResourceToken() {
        return this.keyOrResourceToken;
    }

    public CosmosClientBuilder resourceToken(String resourceToken) {
        this.keyOrResourceToken = resourceToken;
        return this;
    }

    List<CosmosPermissionProperties> getPermissions() {
        return this.permissions;
    }

    public CosmosClientBuilder permissions(List<CosmosPermissionProperties> permissions) {
        this.permissions = permissions;
        return this;
    }

    ConsistencyLevel getConsistencyLevel() {
        return this.desiredConsistencyLevel;
    }

    public CosmosClientBuilder consistencyLevel(ConsistencyLevel desiredConsistencyLevel) {
        this.desiredConsistencyLevel = desiredConsistencyLevel;
        return this;
    }

    ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public CosmosClientBuilder connectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
        return this;
    }

    CosmosKeyCredential getKeyCredential() {
        return this.cosmosKeyCredential;
    }

    public CosmosClientBuilder keyCredential(CosmosKeyCredential cosmosKeyCredential) {
        this.cosmosKeyCredential = cosmosKeyCredential;
        return this;
    }

    public CosmosAsyncClient buildAsyncClient() {
        this.validateConfig();
        return new CosmosAsyncClient(this);
    }

    private void validateConfig() {
        this.ifThrowIllegalArgException(this.serviceEndpoint == null, "cannot buildAsyncClient client without service endpoint");
        this.ifThrowIllegalArgException(this.keyOrResourceToken == null && (this.permissions == null || this.permissions.isEmpty()) && this.cosmosAuthorizationTokenResolver == null && this.cosmosKeyCredential == null, "cannot buildAsyncClient client without any one of key, resource token, permissions, token resolver, and cosmos key credential");
        this.ifThrowIllegalArgException(this.cosmosKeyCredential != null && StringUtils.isEmpty(this.cosmosKeyCredential.getKey()), "cannot buildAsyncClient client without key credential");
    }

    public CosmosClient buildClient() {
        this.validateConfig();
        return new CosmosClient(this);
    }

    Configs configs() {
        return this.configs;
    }

    CosmosClientBuilder configs(Configs configs) {
        this.configs = configs;
        return this;
    }

    private void ifThrowIllegalArgException(boolean value, String error) {
        if (value) {
            throw new IllegalArgumentException(error);
        }
    }
}

