/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.CosmosAsyncScripts;
import com.azure.cosmos.CosmosClientException;
import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.CosmosStoredProcedure;
import com.azure.cosmos.CosmosTrigger;
import com.azure.cosmos.CosmosUserDefinedFunction;
import com.azure.cosmos.models.CosmosAsyncStoredProcedureResponse;
import com.azure.cosmos.models.CosmosAsyncTriggerResponse;
import com.azure.cosmos.models.CosmosAsyncUserDefinedFunctionResponse;
import com.azure.cosmos.models.CosmosStoredProcedureProperties;
import com.azure.cosmos.models.CosmosStoredProcedureRequestOptions;
import com.azure.cosmos.models.CosmosStoredProcedureResponse;
import com.azure.cosmos.models.CosmosTriggerProperties;
import com.azure.cosmos.models.CosmosTriggerResponse;
import com.azure.cosmos.models.CosmosUserDefinedFunctionProperties;
import com.azure.cosmos.models.CosmosUserDefinedFunctionResponse;
import com.azure.cosmos.models.FeedOptions;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.SqlQuerySpec;
import com.azure.cosmos.util.CosmosPagedFlux;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.azure.cosmos.util.UtilBridgeInternal;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosScripts {
    private final CosmosContainer container;
    private final CosmosAsyncScripts asyncScripts;

    CosmosScripts(CosmosContainer container, CosmosAsyncScripts asyncScripts) {
        this.container = container;
        this.asyncScripts = asyncScripts;
    }

    public CosmosStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties) throws CosmosClientException {
        return this.mapStoredProcedureResponseAndBlock(this.asyncScripts.createStoredProcedure(properties, new CosmosStoredProcedureRequestOptions()));
    }

    public CosmosStoredProcedureResponse createStoredProcedure(CosmosStoredProcedureProperties properties, CosmosStoredProcedureRequestOptions options) throws CosmosClientException {
        return this.mapStoredProcedureResponseAndBlock(this.asyncScripts.createStoredProcedure(properties, options));
    }

    public CosmosPagedIterable<CosmosStoredProcedureProperties> readAllStoredProcedures(FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllStoredProcedures(options));
    }

    public CosmosPagedIterable<CosmosStoredProcedureProperties> queryStoredProcedures(String query, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryStoredProcedures(query, options));
    }

    public CosmosPagedIterable<CosmosStoredProcedureProperties> queryStoredProcedures(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryStoredProcedures(querySpec, options));
    }

    public CosmosStoredProcedure getStoredProcedure(String id) {
        return new CosmosStoredProcedure(id, this.container, this.asyncScripts.getStoredProcedure(id));
    }

    public CosmosUserDefinedFunctionResponse createUserDefinedFunction(CosmosUserDefinedFunctionProperties properties) throws CosmosClientException {
        return this.mapUDFResponseAndBlock(this.asyncScripts.createUserDefinedFunction(properties));
    }

    public CosmosPagedIterable<CosmosUserDefinedFunctionProperties> readAllUserDefinedFunctions(FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllUserDefinedFunctions(options));
    }

    public CosmosPagedIterable<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(String query, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryUserDefinedFunctions(new SqlQuerySpec(query), options));
    }

    public CosmosPagedIterable<CosmosUserDefinedFunctionProperties> queryUserDefinedFunctions(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryUserDefinedFunctions(querySpec, options));
    }

    public CosmosUserDefinedFunction getUserDefinedFunction(String id) {
        return new CosmosUserDefinedFunction(id, this.container, this.asyncScripts.getUserDefinedFunction(id));
    }

    public CosmosTriggerResponse createTrigger(CosmosTriggerProperties properties) throws CosmosClientException {
        return this.mapTriggerResponseAndBlock(this.asyncScripts.createTrigger(properties));
    }

    public CosmosPagedIterable<CosmosTriggerProperties> readAllTriggers(FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.readAllTriggers(options));
    }

    public CosmosPagedIterable<CosmosTriggerProperties> queryTriggers(String query, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryTriggers(query, options));
    }

    public CosmosPagedIterable<CosmosTriggerProperties> queryTriggers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.getCosmosPagedIterable(this.asyncScripts.queryTriggers(querySpec, options));
    }

    public CosmosTrigger getTrigger(String id) {
        return new CosmosTrigger(id, this.container, this.asyncScripts.getTrigger(id));
    }

    CosmosStoredProcedureResponse mapStoredProcedureResponseAndBlock(Mono<CosmosAsyncStoredProcedureResponse> storedProcedureResponseMono) throws CosmosClientException {
        try {
            return (CosmosStoredProcedureResponse)storedProcedureResponseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)((Object)throwable);
            }
            throw ex;
        }
    }

    CosmosStoredProcedureResponse convertResponse(CosmosAsyncStoredProcedureResponse response) {
        if (response.getStoredProcedure() != null) {
            return ModelBridgeInternal.createCosmosStoredProcedureResponse(response, this.getStoredProcedure(response.getStoredProcedure().id()));
        }
        return ModelBridgeInternal.createCosmosStoredProcedureResponse(response, null);
    }

    CosmosUserDefinedFunctionResponse mapUDFResponseAndBlock(Mono<CosmosAsyncUserDefinedFunctionResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosUserDefinedFunctionResponse)responseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosUserDefinedFunctionResponse convertResponse(CosmosAsyncUserDefinedFunctionResponse response) {
        if (response.getUserDefinedFunction() != null) {
            return ModelBridgeInternal.createCosmosUserDefinedFunctionResponse(response, this.getUserDefinedFunction(response.getUserDefinedFunction().getId()));
        }
        return ModelBridgeInternal.createCosmosUserDefinedFunctionResponse(response, null);
    }

    CosmosTriggerResponse mapTriggerResponseAndBlock(Mono<CosmosAsyncTriggerResponse> responseMono) throws CosmosClientException {
        try {
            return (CosmosTriggerResponse)responseMono.map(this::convertResponse).block();
        }
        catch (Exception ex) {
            Throwable throwable = Exceptions.unwrap((Throwable)ex);
            if (throwable instanceof CosmosClientException) {
                throw (CosmosClientException)((Object)throwable);
            }
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    CosmosTriggerResponse convertResponse(CosmosAsyncTriggerResponse response) {
        if (response.getTrigger() != null) {
            return ModelBridgeInternal.createCosmosTriggerResponse(response, this.getTrigger(response.getTrigger().getId()));
        }
        return ModelBridgeInternal.createCosmosTriggerResponse(response, null);
    }

    private <T> CosmosPagedIterable<T> getCosmosPagedIterable(CosmosPagedFlux<T> cosmosPagedFlux) {
        return UtilBridgeInternal.createCosmosPagedIterable(cosmosPagedFlux);
    }
}

